"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HiddenDocuments = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../../data_panel");
var _constants = require("../../constants");
var _constants2 = require("../constants");
var _curation_logic = require("../curation_logic");
var _results = require("../results");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HiddenDocuments = () => {
  const {
    clearHiddenIds,
    removeHiddenId
  } = (0, _kea.useActions)(_curation_logic.CurationLogic);
  const {
    curation,
    hiddenDocumentsLoading
  } = (0, _kea.useValues)(_curation_logic.CurationLogic);
  const documents = curation.hidden;
  const hasDocuments = documents.length > 0;
  const CountBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "accent"
  }, documents.length);
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    iconType: CountBadge,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.HIDDEN_DOCUMENTS_TITLE),
    action: hasDocuments && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: clearHiddenIds,
      size: "s"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.hiddenDocuments.removeAllButtonLabel', {
      defaultMessage: 'Unhide all'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_results.AddResultButton, null))),
    isLoading: hiddenDocumentsLoading
  }, hasDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, documents.map((document, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_results.CurationResult, {
    result: (0, _results.convertToResultFormat)(document),
    index: index,
    actions: [{
      ..._constants.SHOW_DOCUMENT_ACTION,
      onClick: () => removeHiddenId(document.id)
    }]
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.hiddenDocuments.emptyTitle', {
      defaultMessage: "You haven't hidden any documents yet"
    })),
    body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.hiddenDocuments.emptyDescription', {
      defaultMessage: 'Hide documents by clicking the eye icon on the organic results above, or search and hide a result manually.'
    }),
    actions: /*#__PURE__*/_react.default.createElement(_results.AddResultButton, null)
  }));
};
exports.HiddenDocuments = HiddenDocuments;