"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../common");
var _services = require("./services");
var _service = require("./services/palettes/service");
var _active_cursor = require("./services/active_cursor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

/** @public */

/** @public */
class ChartsPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "themeService", new _services.ThemeService());
    (0, _defineProperty2.default)(this, "legacyColorsService", new _services.LegacyColorsService());
    (0, _defineProperty2.default)(this, "paletteService", new _service.PaletteService());
    (0, _defineProperty2.default)(this, "activeCursor", new _active_cursor.ActiveCursor());
    (0, _defineProperty2.default)(this, "palettes", void 0);
  }
  setup(core, dependencies) {
    dependencies.expressions.registerFunction(_common.palette);
    dependencies.expressions.registerFunction(_common.systemPalette);
    this.themeService.init(core.theme);
    this.legacyColorsService.init(core.uiSettings);
    this.palettes = this.paletteService.setup(core.theme.getTheme(), this.legacyColorsService);
    this.activeCursor.setup();
    return {
      legacyColors: this.legacyColorsService,
      theme: this.themeService,
      palettes: this.palettes
    };
  }
  start() {
    return {
      legacyColors: this.legacyColorsService,
      theme: this.themeService,
      palettes: this.palettes,
      activeCursor: this.activeCursor
    };
  }
}
exports.ChartsPlugin = ChartsPlugin;