# frozen_string_literal: true
class Views::SharedTogo::Head < ::Views::Base
  needs(:view_title)
  needs(:stylesheet_link_tags => ['shared_togo/enterprise_search_home'])
  needs(:stylesheet_packs_with_chunks_tags => ['eui'])
  needs(:javascript_packs_with_chunks_tags => [])
  needs(:product => 'enterprise-search')
  needs(:no_referrer => false)

  def content
    doctype!
    head do
      title(view_title)
      widget Views::Shared::Favicon, :product => product
      common_meta_tags
      meta(:name => 'referrer', :content => 'no-referrer') if no_referrer
      stylesheet_link_tags.each do |link_tag|
        stylesheet_link_tag(link_tag)
      end

      stylesheet_packs_with_chunks_tag(*stylesheet_packs_with_chunks_tags) if stylesheet_packs_with_chunks_tags.any?
    end
  end
end
