# frozen_string_literal: true
class Views::LocoMoco::Dashboard::Invitations::Show < ::Views::Base
  needs :lm_invitation

  def view_title
    'App Search'
  end

  def content
    widget(
      Views::SharedTogo::Head,
      :product => 'app-search',
      :view_title => "Elastic #{view_title}",
      :stylesheet_link_tags => ['shared_togo/enterprise_search_home'],
      :stylesheet_packs_with_chunks_tags => ['eui'],
      :javascript_packs_with_chunks_tags => []
    )

    widget(
      Views::SharedTogo::AuthBody,
      :view_title => view_title,
      :product_icon => 'shared/products/icon-app-search.svg',
      :product_version => AppConfig.product_version
    ) do
      if lm_invitation.active?
        widget(
          Views::SharedTogo::AcceptInvite,
          :invitation => lm_invitation,
          :invitation_code_param => :lm_invitation_code
        )
      else
        div(:class => 'euiTextAlign euiTextAlign--center') do
          p('This invitation has expired. Please ask your Elastic App Search Owner to re-invite.', :class => 'euiTitle euiTitle--medium')
        end
      end
    end
  end
end
