/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.global.Global;
import org.elasticsearch.search.aggregations.metrics.AbstractGeoTestCase;
import org.elasticsearch.search.aggregations.metrics.CentroidAggregation;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matchers;

@ESIntegTestCase.SuiteScopeTestCase
public abstract class CentroidAggregationTestBase
extends AbstractGeoTestCase {
    protected abstract String aggName();

    protected abstract ValuesSourceAggregationBuilder<?> centroidAgg(String var1);

    public void testEmptyAggregation() {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)CentroidAggregationTestBase.client().prepareSearch(new String[]{"empty_idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AggregationBuilder)this.centroidAgg(this.aggName()).field("spatial_value")), response -> {
            CentroidAggregation geoCentroid = (CentroidAggregation)response.getAggregations().get(this.aggName());
            CentroidAggregationTestBase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)0L));
            CentroidAggregationTestBase.assertThat(geoCentroid, Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(geoCentroid.getName(), Matchers.equalTo((Object)this.aggName()));
            CentroidAggregationTestBase.assertThat(geoCentroid.centroid(), Matchers.equalTo(null));
            CentroidAggregationTestBase.assertEquals((long)0L, (long)geoCentroid.count());
        });
    }

    public void testUnmapped() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)CentroidAggregationTestBase.client().prepareSearch(new String[]{"idx_unmapped"}).addAggregation((AggregationBuilder)this.centroidAgg(this.aggName()).field("spatial_value")), response -> {
            CentroidAggregation geoCentroid = (CentroidAggregation)response.getAggregations().get(this.aggName());
            CentroidAggregationTestBase.assertThat(geoCentroid, Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(geoCentroid.getName(), Matchers.equalTo((Object)this.aggName()));
            CentroidAggregationTestBase.assertThat(geoCentroid.centroid(), Matchers.equalTo(null));
            CentroidAggregationTestBase.assertEquals((long)0L, (long)geoCentroid.count());
        });
    }

    public void testPartiallyUnmapped() {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)CentroidAggregationTestBase.client().prepareSearch(new String[]{"idx", "idx_unmapped"}).addAggregation((AggregationBuilder)this.centroidAgg(this.aggName()).field("spatial_value")), response -> {
            CentroidAggregation geoCentroid = (CentroidAggregation)response.getAggregations().get(this.aggName());
            CentroidAggregationTestBase.assertThat(geoCentroid, Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(geoCentroid.getName(), Matchers.equalTo((Object)this.aggName()));
            this.assertSameCentroid(geoCentroid.centroid(), singleCentroid);
            CentroidAggregationTestBase.assertEquals((long)numDocs, (long)geoCentroid.count());
        });
    }

    public void testSingleValuedField() {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)CentroidAggregationTestBase.client().prepareSearch(new String[]{"idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AggregationBuilder)this.centroidAgg(this.aggName()).field("spatial_value")), response -> {
            CentroidAggregation geoCentroid = (CentroidAggregation)response.getAggregations().get(this.aggName());
            CentroidAggregationTestBase.assertThat(geoCentroid, Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(geoCentroid.getName(), Matchers.equalTo((Object)this.aggName()));
            this.assertSameCentroid(geoCentroid.centroid(), singleCentroid);
            CentroidAggregationTestBase.assertEquals((long)numDocs, (long)geoCentroid.count());
        });
    }

    public void testSingleValueFieldGetProperty() {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)CentroidAggregationTestBase.client().prepareSearch(new String[]{"idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AggregationBuilder)AggregationBuilders.global((String)"global").subAggregation((AggregationBuilder)this.centroidAgg(this.aggName()).field("spatial_value"))), response -> {
            Global global = (Global)response.getAggregations().get("global");
            CentroidAggregationTestBase.assertThat(global, Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(global.getName(), Matchers.equalTo((Object)"global"));
            CentroidAggregationTestBase.assertThat(global.getDocCount(), Matchers.equalTo((Object)numDocs));
            CentroidAggregationTestBase.assertThat(global.getAggregations(), Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(global.getAggregations().asList().size(), Matchers.equalTo((Object)1));
            CentroidAggregation geoCentroid = (CentroidAggregation)global.getAggregations().get(this.aggName());
            InternalAggregation agg = (InternalAggregation)global;
            CentroidAggregationTestBase.assertThat(geoCentroid, Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(geoCentroid.getName(), Matchers.equalTo((Object)this.aggName()));
            CentroidAggregationTestBase.assertThat((CentroidAggregation)agg.getProperty(this.aggName()), Matchers.sameInstance((Object)geoCentroid));
            this.assertSameCentroid(geoCentroid.centroid(), singleCentroid);
            this.assertSimilarValue(((SpatialPoint)agg.getProperty(this.aggName() + ".value")).getY(), singleCentroid.getY());
            this.assertSimilarValue(((SpatialPoint)agg.getProperty(this.aggName() + ".value")).getX(), singleCentroid.getX());
            this.assertSimilarValue((Double)agg.getProperty(this.aggName() + "." + this.coordinateName("y")), singleCentroid.getY());
            this.assertSimilarValue((Double)agg.getProperty(this.aggName() + "." + this.coordinateName("x")), singleCentroid.getX());
            CentroidAggregationTestBase.assertEquals((long)numDocs, (long)((Long)((InternalAggregation)global).getProperty(this.aggName() + ".count")));
        });
    }

    public void testMultiValuedField() throws Exception {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)CentroidAggregationTestBase.client().prepareSearch(new String[]{"idx"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addAggregation((AggregationBuilder)this.centroidAgg(this.aggName()).field("spatial_values")), response -> {
            CentroidAggregation geoCentroid = (CentroidAggregation)response.getAggregations().get(this.aggName());
            CentroidAggregationTestBase.assertThat(geoCentroid, Matchers.notNullValue());
            CentroidAggregationTestBase.assertThat(geoCentroid.getName(), Matchers.equalTo((Object)this.aggName()));
            this.assertSameCentroid(geoCentroid.centroid(), multiCentroid);
            CentroidAggregationTestBase.assertEquals((long)(2 * numDocs), (long)geoCentroid.count());
        });
    }

    protected String coordinateName(String coordinate) {
        return coordinate;
    }

    protected double tolerance(double a, double b) {
        return 1.0E-5;
    }

    protected double normalize(double value) {
        return value;
    }

    protected void assertSimilarValue(double a, double b) {
        a = this.normalize(a);
        b = this.normalize(b);
        CentroidAggregationTestBase.assertThat(a, Matchers.closeTo((double)b, (double)this.tolerance(a, b)));
    }

    protected void assertSameCentroid(SpatialPoint centroid, SpatialPoint expectedCentroid) {
        String[] stringArray;
        if (centroid.getClass() == GeoPoint.class) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "longitude";
            stringArray = stringArray2;
            stringArray2[1] = "latitude";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "x";
            stringArray = stringArray3;
            stringArray3[1] = "y";
        }
        String[] names = stringArray;
        double x = this.normalize(centroid.getX());
        double y = this.normalize(centroid.getY());
        double ex = this.normalize(expectedCentroid.getX());
        double ey = this.normalize(expectedCentroid.getY());
        CentroidAggregationTestBase.assertThat("Mismatching value for '" + names[0] + "' field of centroid", x, Matchers.closeTo((double)ex, (double)this.tolerance(x, ex)));
        CentroidAggregationTestBase.assertThat("Mismatching value for '" + names[1] + "' field of centroid", y, Matchers.closeTo((double)ey, (double)this.tolerance(y, ey)));
    }
}

