/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.SearchSortValues;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import org.elasticsearch.search.profile.query.CollectorResult;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.Text;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class SearchResponseUtils
extends Enum<SearchResponseUtils> {
    public static final ObjectParser.UnknownFieldConsumer<Map<String, Object>> unknownMetaFieldConsumer;
    private static final ParseField RESPONSES;
    private static final ParseField TOOK_IN_MILLIS;
    private static final ConstructingObjectParser<MultiSearchResponse, Void> MULTI_SEARCH_RESPONSE_PARSER;
    private static final InstantiatingObjectParser<SearchProfileDfsPhaseResult, Void> PROFILE_DFS_PHASE_RESULT_PARSER;
    static final ObjectParser<Map<String, Object>, Void> MAP_PARSER;
    private static final ConstructingObjectParser<SearchHit.NestedIdentity, Void> NESTED_IDENTITY_PARSER;
    private static final /* synthetic */ SearchResponseUtils[] $VALUES;

    public static SearchResponseUtils[] values() {
        return (SearchResponseUtils[])$VALUES.clone();
    }

    public static SearchResponseUtils valueOf(String name) {
        return Enum.valueOf(SearchResponseUtils.class, name);
    }

    public static TotalHits getTotalHits(SearchRequestBuilder request) {
        SearchResponse resp = (SearchResponse)request.get();
        try {
            TotalHits totalHits = resp.getHits().getTotalHits();
            return totalHits;
        }
        finally {
            resp.decRef();
        }
    }

    public static long getTotalHitsValue(SearchRequestBuilder request) {
        return SearchResponseUtils.getTotalHits((SearchRequestBuilder)request).value;
    }

    public static SearchResponse responseAsSearchResponse(Response searchResponse) throws IOException {
        try (XContentParser parser = ESRestTestCase.responseAsParser(searchResponse);){
            SearchResponse searchResponse2 = SearchResponseUtils.parseSearchResponse(parser);
            return searchResponse2;
        }
    }

    public static SearchResponse emptyWithTotalHits(String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, SearchResponse.Clusters clusters) {
        return new SearchResponse(SearchHits.EMPTY_WITH_TOTAL_HITS, null, null, false, null, null, 1, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, shardFailures, clusters);
    }

    public static SearchResponse parseSearchResponse(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        parser.nextToken();
        return SearchResponseUtils.parseInnerSearchResponse(parser);
    }

    public static MultiSearchResponse parseMultiSearchResponse(XContentParser parser) {
        return (MultiSearchResponse)MULTI_SEARCH_RESPONSE_PARSER.apply(parser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static MultiSearchResponse.Item itemFromXContent(XContentParser parser) throws IOException {
        MultiSearchResponse.Item item = null;
        String fieldName = null;
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        block4: while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    fieldName = parser.currentName();
                    if ("error".equals(fieldName)) {
                        item = new MultiSearchResponse.Item(null, (Exception)ElasticsearchException.failureFromXContent((XContentParser)parser));
                        break;
                    }
                    if ("status".equals(fieldName)) break;
                    item = new MultiSearchResponse.Item(SearchResponseUtils.parseInnerSearchResponse(parser), null);
                    break block4;
                }
                case VALUE_NUMBER: {
                    if (!"status".equals(fieldName)) break;
                }
            }
            token = parser.nextToken();
        }
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT);
        return item;
    }

    public static SearchResponse parseInnerSearchResponse(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String currentFieldName = parser.currentName();
        SearchHits hits = null;
        InternalAggregations aggs = null;
        Suggest suggest = null;
        SearchProfileResults profile = null;
        boolean timedOut = false;
        Boolean terminatedEarly = null;
        int numReducePhases = 1;
        long tookInMillis = -1L;
        int successfulShards = -1;
        int totalShards = -1;
        int skippedShards = 0;
        String scrollId = null;
        BytesArray searchContextId = null;
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        SearchResponse.Clusters clusters = SearchResponse.Clusters.EMPTY;
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if (token.isValue()) {
                if (SearchResponse.SCROLL_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    scrollId = parser.text();
                } else if (SearchResponse.POINT_IN_TIME_ID.match(currentFieldName, parser.getDeprecationHandler())) {
                    searchContextId = new BytesArray(Base64.getUrlDecoder().decode(parser.text()));
                } else if (SearchResponse.TOOK.match(currentFieldName, parser.getDeprecationHandler())) {
                    tookInMillis = parser.longValue();
                } else if (SearchResponse.TIMED_OUT.match(currentFieldName, parser.getDeprecationHandler())) {
                    timedOut = parser.booleanValue();
                } else if (SearchResponse.TERMINATED_EARLY.match(currentFieldName, parser.getDeprecationHandler())) {
                    terminatedEarly = parser.booleanValue();
                } else if (SearchResponse.NUM_REDUCE_PHASES.match(currentFieldName, parser.getDeprecationHandler())) {
                    numReducePhases = parser.intValue();
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if ("hits".equals(currentFieldName)) {
                    hits = SearchResponseUtils.parseSearchHits(parser);
                } else if ("aggregations".equals(currentFieldName)) {
                    aggs = InternalAggregations.fromXContent((XContentParser)parser);
                } else if ("suggest".equals(currentFieldName)) {
                    suggest = SearchResponseUtils.parseSuggest(parser);
                } else if ("profile".equals(currentFieldName)) {
                    profile = SearchResponseUtils.parseSearchProfileResults(parser);
                } else if (RestActions._SHARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if (RestActions.FAILED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                parser.intValue();
                                continue;
                            }
                            if (RestActions.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                successfulShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                totalShards = parser.intValue();
                                continue;
                            }
                            if (RestActions.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                skippedShards = parser.intValue();
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            if (RestActions.FAILURES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    failures.add(ShardSearchFailure.fromXContent((XContentParser)parser));
                                }
                                continue;
                            }
                            parser.skipChildren();
                            continue;
                        }
                        parser.skipChildren();
                    }
                } else if (SearchResponse.Clusters._CLUSTERS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    clusters = SearchResponseUtils.parseClusters(parser);
                } else {
                    parser.skipChildren();
                }
            }
            token = parser.nextToken();
        }
        return new SearchResponse(hits, aggs, suggest, timedOut, terminatedEarly, profile, numReducePhases, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, failures.toArray(ShardSearchFailure.EMPTY_ARRAY), clusters, searchContextId);
    }

    private static SearchResponse.Clusters parseClusters(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        int total = -1;
        int successful = -1;
        int skipped = -1;
        int running = 0;
        int partial = 0;
        int failed = 0;
        ConcurrentMap clusterInfoMap = ConcurrentCollections.newConcurrentMap();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SearchResponse.Clusters.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    total = parser.intValue();
                    continue;
                }
                if (SearchResponse.Clusters.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    successful = parser.intValue();
                    continue;
                }
                if (SearchResponse.Clusters.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    skipped = parser.intValue();
                    continue;
                }
                if (SearchResponse.Clusters.RUNNING_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    running = parser.intValue();
                    continue;
                }
                if (SearchResponse.Clusters.PARTIAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    partial = parser.intValue();
                    continue;
                }
                if (SearchResponse.Clusters.FAILED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    failed = parser.intValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (SearchResponse.Clusters.DETAILS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    String currentDetailsFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentDetailsFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.START_OBJECT) {
                            SearchResponse.Cluster c = SearchResponseUtils.parseCluster(currentDetailsFieldName, parser);
                            clusterInfoMap.put(currentDetailsFieldName, c);
                            continue;
                        }
                        parser.skipChildren();
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        if (clusterInfoMap.isEmpty()) {
            assert (running == 0 && partial == 0 && failed == 0) : "Non cross-cluster should have counter for running, partial and failed equal to 0";
            return new SearchResponse.Clusters(total, successful, skipped);
        }
        return new SearchResponse.Clusters((Map)clusterInfoMap);
    }

    private static SearchResponse.Cluster parseCluster(String clusterAlias, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        String clusterName = clusterAlias;
        if (clusterAlias.equals("(local)")) {
            clusterName = "";
        }
        String indexExpression = null;
        String status = "running";
        boolean timedOut = false;
        long took = -1L;
        int totalShards = -1;
        int successfulShards = -1;
        int skippedShards = -1;
        int failedShards = -1;
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SearchResponse.Cluster.INDICES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexExpression = parser.text();
                    continue;
                }
                if (SearchResponse.Cluster.STATUS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    status = parser.text();
                    continue;
                }
                if (SearchResponse.TIMED_OUT.match(currentFieldName, parser.getDeprecationHandler())) {
                    timedOut = parser.booleanValue();
                    continue;
                }
                if (SearchResponse.TOOK.match(currentFieldName, parser.getDeprecationHandler())) {
                    took = parser.longValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (RestActions._SHARDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (RestActions.FAILED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            failedShards = parser.intValue();
                            continue;
                        }
                        if (RestActions.SUCCESSFUL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            successfulShards = parser.intValue();
                            continue;
                        }
                        if (RestActions.TOTAL_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            totalShards = parser.intValue();
                            continue;
                        }
                        if (RestActions.SKIPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            skippedShards = parser.intValue();
                            continue;
                        }
                        parser.skipChildren();
                        continue;
                    }
                    parser.skipChildren();
                }
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (RestActions.FAILURES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        failures.add(ShardSearchFailure.fromXContent((XContentParser)parser));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        Integer totalShardsFinal = totalShards == -1 ? null : Integer.valueOf(totalShards);
        Integer successfulShardsFinal = successfulShards == -1 ? null : Integer.valueOf(successfulShards);
        Integer skippedShardsFinal = skippedShards == -1 ? null : Integer.valueOf(skippedShards);
        Integer failedShardsFinal = failedShards == -1 ? null : Integer.valueOf(failedShards);
        TimeValue tookTimeValue = took == -1L ? null : new TimeValue(took);
        return new SearchResponse.Cluster(clusterName, indexExpression, false, SearchResponse.Cluster.Status.valueOf((String)status.toUpperCase(Locale.ROOT)), totalShardsFinal, successfulShardsFinal, skippedShardsFinal, failedShardsFinal, failures, tookTimeValue, timedOut);
    }

    public static SearchProfileResults parseSearchProfileResults(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        HashMap<String, SearchProfileShardResult> profileResults = new HashMap<String, SearchProfileShardResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_ARRAY) {
                if ("shards".equals(parser.currentName())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        SearchResponseUtils.parseProfileResultsEntry(parser, profileResults);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            parser.skipChildren();
        }
        return new SearchProfileResults(profileResults);
    }

    private static void parseProfileResultsEntry(XContentParser parser, Map<String, SearchProfileShardResult> searchProfileResults) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        SearchProfileDfsPhaseResult searchProfileDfsPhaseResult = null;
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>();
        AggregationProfileShardResult aggProfileShardResult = null;
        ProfileResult fetchResult = null;
        String id = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("id".equals(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("searches".equals(currentFieldName)) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        queryProfileResults.add(SearchResponseUtils.parseQueryProfileShardResult(parser));
                    }
                    continue;
                }
                if ("aggregations".equals(currentFieldName)) {
                    aggProfileShardResult = AggregationProfileShardResult.fromXContent((XContentParser)parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("dfs".equals(currentFieldName)) {
                    searchProfileDfsPhaseResult = SearchResponseUtils.parseProfileDfsPhaseResult(parser);
                    continue;
                }
                if ("fetch".equals(currentFieldName)) {
                    fetchResult = ProfileResult.fromXContent((XContentParser)parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        SearchProfileShardResult result = new SearchProfileShardResult(new SearchProfileQueryPhaseResult(queryProfileResults, aggProfileShardResult), fetchResult);
        result.getQueryPhase().setSearchProfileDfsPhaseResult(searchProfileDfsPhaseResult);
        searchProfileResults.put(id, result);
    }

    public static SearchProfileDfsPhaseResult parseProfileDfsPhaseResult(XContentParser parser) throws IOException {
        return (SearchProfileDfsPhaseResult)PROFILE_DFS_PHASE_RESULT_PARSER.parse(parser, null);
    }

    public static QueryProfileShardResult parseQueryProfileShardResult(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        String currentFieldName = null;
        ArrayList<ProfileResult> queryProfileResults = new ArrayList<ProfileResult>();
        long rewriteTime = 0L;
        Long vectorOperationsCount = null;
        CollectorResult collector = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("rewrite_time".equals(currentFieldName)) {
                    rewriteTime = parser.longValue();
                    continue;
                }
                if ("vector_operations_count".equals(currentFieldName)) {
                    vectorOperationsCount = parser.longValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("query".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        queryProfileResults.add(ProfileResult.fromXContent((XContentParser)parser));
                    }
                    continue;
                }
                if ("collector".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        collector = CollectorResult.fromXContent((XContentParser)parser);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        return new QueryProfileShardResult(queryProfileResults, rewriteTime, collector, vectorOperationsCount);
    }

    public static SearchHits parseSearchHits(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        }
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        TotalHits totalHits = null;
        float maxScore = 0.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("total".equals(currentFieldName)) {
                    long value = parser.longValue();
                    totalHits = value == -1L ? null : new TotalHits(value, TotalHits.Relation.EQUAL_TO);
                    continue;
                }
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = parser.floatValue();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if (!"max_score".equals(currentFieldName)) continue;
                maxScore = Float.NaN;
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("hits".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        hits.add(SearchResponseUtils.parseSearchHit(parser));
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if ("total".equals(currentFieldName)) {
                totalHits = SearchHits.parseTotalHitsFragment((XContentParser)parser);
                continue;
            }
            parser.skipChildren();
        }
        return SearchHits.unpooled((SearchHit[])hits.toArray(SearchHits.EMPTY), totalHits, (float)maxScore);
    }

    public static SearchHit parseSearchHit(XContentParser parser) {
        return SearchResponseUtils.searchHitFromMap((Map)MAP_PARSER.apply(parser, null));
    }

    public static void declareInnerHitsParseFields(ObjectParser<Map<String, Object>, Void> parser) {
        parser.declareString((map, value) -> map.put("_index", value), new ParseField("_index", new String[0]));
        parser.declareString((map, value) -> map.put("_id", value), new ParseField("_id", new String[0]));
        parser.declareString((map, value) -> map.put("_node", value), new ParseField("_node", new String[0]));
        parser.declareField((map, value) -> map.put("_score", value), SearchResponseUtils::parseScore, new ParseField("_score", new String[0]), ObjectParser.ValueType.FLOAT_OR_NULL);
        parser.declareInt((map, value) -> map.put("_rank", value), new ParseField("_rank", new String[0]));
        parser.declareLong((map, value) -> map.put("_version", value), new ParseField("_version", new String[0]));
        parser.declareLong((map, value) -> map.put("_seq_no", value), new ParseField("_seq_no", new String[0]));
        parser.declareLong((map, value) -> map.put("_primary_term", value), new ParseField("_primary_term", new String[0]));
        parser.declareField((map, value) -> map.put("_shard", value), (p, c) -> ShardId.fromString((String)p.text()), new ParseField("_shard", new String[0]), ObjectParser.ValueType.STRING);
        parser.declareObject((map, value) -> map.put("_source", value), (p, c) -> SearchResponseUtils.parseSourceBytes(p), new ParseField("_source", new String[0]));
        parser.declareObject((map, value) -> map.put("highlight", value), (p, c) -> SearchResponseUtils.parseHighlightFields(p), new ParseField("highlight", new String[0]));
        parser.declareObject((map, value) -> {
            Map fieldMap = SearchResponseUtils.get("fields", map, new HashMap());
            fieldMap.putAll(value);
            map.put("document_fields", fieldMap);
        }, (p, c) -> SearchResponseUtils.parseFields(p), new ParseField("fields", new String[0]));
        parser.declareObject((map, value) -> map.put("_explanation", value), (p, c) -> SearchResponseUtils.parseExplanation(p), new ParseField("_explanation", new String[0]));
        parser.declareObject((map, value) -> map.put("_nested", value), (p, ignored) -> SearchResponseUtils.parseNestedIdentity(p), new ParseField("_nested", new String[0]));
        parser.declareObject((map, value) -> map.put("inner_hits", value), (p, c) -> SearchResponseUtils.parseInnerHits(p), new ParseField("inner_hits", new String[0]));
        parser.declareField((p, map, context) -> {
            XContentParser.Token token = p.currentToken();
            LinkedHashMap<String, Float> matchedQueries = new LinkedHashMap<String, Float>();
            if (token == XContentParser.Token.START_OBJECT) {
                String fieldName = null;
                while ((token = p.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = p.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    matchedQueries.put(fieldName, Float.valueOf(p.floatValue()));
                }
            } else if (token == XContentParser.Token.START_ARRAY) {
                while (p.nextToken() != XContentParser.Token.END_ARRAY) {
                    matchedQueries.put(p.text(), Float.valueOf(Float.NaN));
                }
            }
            map.put("matched_queries", matchedQueries);
        }, new ParseField("matched_queries", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        parser.declareField((map, list) -> map.put("sort", list), SearchSortValues::fromXContent, new ParseField("sort", new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
    }

    private static float parseScore(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER || parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return parser.floatValue();
        }
        return Float.NaN;
    }

    private static BytesReference parseSourceBytes(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());){
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    private static Map<String, DocumentField> parseFields(XContentParser parser) throws IOException {
        HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            DocumentField field = DocumentField.fromXContent((XContentParser)parser);
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private static Map<String, SearchHits> parseInnerHits(XContentParser parser) throws IOException {
        HashMap<String, SearchHits> innerHits = new HashMap<String, SearchHits>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            String name = parser.currentName();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            XContentParserUtils.ensureFieldName((XContentParser)parser, (XContentParser.Token)parser.nextToken(), (String)"hits");
            innerHits.put(name, SearchResponseUtils.parseSearchHits(parser));
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        }
        return innerHits;
    }

    private static Map<String, HighlightField> parseHighlightFields(XContentParser parser) throws IOException {
        HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            HighlightField highlightField = HighlightField.fromXContent((XContentParser)parser);
            highlightFields.put(highlightField.name(), highlightField);
        }
        return highlightFields;
    }

    private static Explanation parseExplanation(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        Float value = null;
        String description = null;
        ArrayList<Explanation> details = new ArrayList<Explanation>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if ("value".equals(currentFieldName)) {
                value = Float.valueOf(parser.floatValue());
                continue;
            }
            if ("description".equals(currentFieldName)) {
                description = parser.textOrNull();
                continue;
            }
            if ("details".equals(currentFieldName)) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    details.add(SearchResponseUtils.parseExplanation(parser));
                }
                continue;
            }
            parser.skipChildren();
        }
        if (value == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation value", new Object[0]);
        }
        if (description == null) {
            throw new ParsingException(parser.getTokenLocation(), "missing explanation description", new Object[0]);
        }
        return Explanation.match(value, description, details);
    }

    public static Suggest parseSuggest(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            String currentField = parser.currentName();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion = SearchResponseUtils.parseSuggestion(parser);
            if (suggestion != null) {
                suggestions.add(suggestion);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Could not parse suggestion keyed as [%s]", currentField), new Object[0]);
        }
        return new Suggest(suggestions);
    }

    public static Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> parseSuggestion(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        SetOnce suggestion = new SetOnce();
        XContentParserUtils.parseTypedKeysObject((XContentParser)parser, (String)"#", Suggest.Suggestion.class, arg_0 -> ((SetOnce)suggestion).set(arg_0));
        return (Suggest.Suggestion)suggestion.get();
    }

    public static SearchHit.NestedIdentity parseNestedIdentity(XContentParser parser) {
        return (SearchHit.NestedIdentity)NESTED_IDENTITY_PARSER.apply(parser, null);
    }

    public static SearchHit searchHitFromMap(Map<String, Object> values) {
        SearchShardTarget shardTarget;
        String id = SearchResponseUtils.get("_id", values, null);
        String index = SearchResponseUtils.get("_index", values, null);
        String clusterAlias = null;
        if (index != null) {
            String[] split = RemoteClusterAware.splitIndexName((String)index);
            clusterAlias = split[0];
            index = split[1];
        }
        ShardId shardId = SearchResponseUtils.get("_shard", values, null);
        String nodeId = SearchResponseUtils.get("_node", values, null);
        if (shardId != null && nodeId != null) {
            assert (shardId.getIndexName().equals(index));
            shardTarget = new SearchShardTarget(nodeId, shardId, clusterAlias);
            index = shardTarget.getIndex();
            clusterAlias = shardTarget.getClusterAlias();
        } else {
            shardTarget = null;
        }
        return new SearchHit(-1, SearchResponseUtils.get("_score", values, Float.valueOf(Float.NaN)).floatValue(), SearchResponseUtils.get("_rank", values, -1).intValue(), id == null ? null : new Text(id), (SearchHit.NestedIdentity)SearchResponseUtils.get("_nested", values, null), SearchResponseUtils.get("_version", values, -1L).longValue(), SearchResponseUtils.get("_seq_no", values, -2L).longValue(), SearchResponseUtils.get("_primary_term", values, 0L).longValue(), (BytesReference)SearchResponseUtils.get("_source", values, null), (Map)SearchResponseUtils.get("highlight", values, null), SearchResponseUtils.get("sort", values, SearchSortValues.EMPTY), (Map)SearchResponseUtils.get("matched_queries", values, null), (Explanation)SearchResponseUtils.get("_explanation", values, null), shardTarget, index, clusterAlias, (Map)SearchResponseUtils.get("inner_hits", values, null), SearchResponseUtils.get("document_fields", values, Collections.emptyMap()), SearchResponseUtils.get("metadata_fields", values, Collections.emptyMap()), RefCounted.ALWAYS_REFERENCED);
    }

    private static <T> T get(String key, Map<String, Object> map, T defaultValue) {
        return (T)map.getOrDefault(key, defaultValue);
    }

    private static /* synthetic */ SearchResponseUtils[] $values() {
        return new SearchResponseUtils[0];
    }

    static {
        $VALUES = SearchResponseUtils.$values();
        unknownMetaFieldConsumer = (map, fieldName, fieldValue) -> {
            Map fieldMap = (Map)map.computeIfAbsent("metadata_fields", v -> new HashMap());
            if (fieldName.equals("_ignored")) {
                fieldMap.put(fieldName, new DocumentField(fieldName, (List)fieldValue));
            } else {
                fieldMap.put(fieldName, new DocumentField(fieldName, Collections.singletonList(fieldValue)));
            }
        };
        RESPONSES = new ParseField("responses", new String[0]);
        TOOK_IN_MILLIS = new ParseField("took", new String[0]);
        MULTI_SEARCH_RESPONSE_PARSER = new ConstructingObjectParser("multi_search", true, a -> new MultiSearchResponse(((List)a[0]).toArray(new MultiSearchResponse.Item[0]), ((Long)a[1]).longValue()));
        MULTI_SEARCH_RESPONSE_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> SearchResponseUtils.itemFromXContent(p), RESPONSES);
        MULTI_SEARCH_RESPONSE_PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOOK_IN_MILLIS);
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"search_profile_dfs_phase_result", (boolean)true, SearchProfileDfsPhaseResult.class);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ProfileResult.fromXContent((XContentParser)p), SearchProfileDfsPhaseResult.STATISTICS);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchResponseUtils.parseQueryProfileShardResult(p), SearchProfileDfsPhaseResult.KNN);
        PROFILE_DFS_PHASE_RESULT_PARSER = parser.build();
        MAP_PARSER = new ObjectParser("innerHitParser", unknownMetaFieldConsumer, HashMap::new);
        SearchResponseUtils.declareInnerHitsParseFields(MAP_PARSER);
        NESTED_IDENTITY_PARSER = new ConstructingObjectParser("nested_identity", true, ctorArgs -> new SearchHit.NestedIdentity((String)ctorArgs[0], ((Integer)ctorArgs[1]).intValue(), (SearchHit.NestedIdentity)ctorArgs[2]));
        NESTED_IDENTITY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("field", new String[0]));
        NESTED_IDENTITY_PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("offset", new String[0]));
        NESTED_IDENTITY_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), NESTED_IDENTITY_PARSER, new ParseField("_nested", new String[0]));
    }
}

