/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;

public class MetaStateWriterUtils {
    private static final Logger logger = LogManager.getLogger(MetaStateWriterUtils.class);

    private MetaStateWriterUtils() {
        throw new AssertionError((Object)"static methods only");
    }

    public static void writeManifestAndCleanup(NodeEnvironment nodeEnv, String reason, Manifest manifest) throws WriteStateException {
        logger.trace("[_meta] writing state, reason [{}]", (Object)reason);
        try {
            long generation = Manifest.FORMAT.writeAndCleanup((Object)manifest, nodeEnv.nodeDataPaths());
            logger.trace("[_meta] state written (generation: {})", (Object)generation);
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(ex.isDirty(), "[_meta]: failed to write meta state", (Exception)((Object)ex));
        }
    }

    public static long writeIndex(NodeEnvironment nodeEnv, String reason, IndexMetadata indexMetadata) throws WriteStateException {
        Index index = indexMetadata.getIndex();
        logger.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            long generation = IndexMetadata.FORMAT.write((Object)indexMetadata, nodeEnv.indexPaths(indexMetadata.getIndex()));
            logger.trace("[{}] state written", (Object)index);
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[" + String.valueOf(index) + "]: failed to write index state", (Exception)((Object)ex));
        }
    }

    static long writeGlobalState(NodeEnvironment nodeEnv, String reason, Metadata metadata) throws WriteStateException {
        logger.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            long generation = Metadata.FORMAT.write((Object)metadata, nodeEnv.nodeDataPaths());
            logger.trace("[_global] state written");
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[_global]: failed to write global state", (Exception)((Object)ex));
        }
    }
}

