/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination.stateless;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.coordination.AbstractCoordinatorTestCase;
import org.elasticsearch.cluster.coordination.stateless.Heartbeat;
import org.elasticsearch.cluster.coordination.stateless.HeartbeatStore;

public class DisruptibleHeartbeatStore
implements HeartbeatStore {
    private static final Logger logger = LogManager.getLogger(DisruptibleHeartbeatStore.class);
    private final HeartbeatStore delegate;
    private final AbstractCoordinatorTestCase.DisruptibleRegisterConnection disruptibleRegisterConnection;

    public DisruptibleHeartbeatStore(HeartbeatStore delegate, AbstractCoordinatorTestCase.DisruptibleRegisterConnection disruptibleRegisterConnection) {
        this.delegate = delegate;
        this.disruptibleRegisterConnection = disruptibleRegisterConnection;
    }

    public final void writeHeartbeat(Heartbeat newHeartbeat, ActionListener<Void> listener) {
        this.disruptibleRegisterConnection.runDisrupted(listener, l -> this.delegate.writeHeartbeat(newHeartbeat, l));
    }

    public final void readLatestHeartbeat(ActionListener<Heartbeat> listener) {
        this.disruptibleRegisterConnection.runDisruptedOrDrop(listener, arg_0 -> ((HeartbeatStore)this.delegate).readLatestHeartbeat(arg_0));
    }
}

