/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.AbstractTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertJapaneseTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BertJapaneseTokenizationUpdate
extends AbstractTokenizationUpdate {
    public static final ParseField NAME = BertJapaneseTokenization.NAME;
    public static ConstructingObjectParser<BertJapaneseTokenizationUpdate, Void> PARSER = new ConstructingObjectParser("bert_japanese_tokenization_update", a -> new BertJapaneseTokenizationUpdate(a[0] == null ? null : Tokenization.Truncate.fromString((String)a[0]), (Integer)a[1]));

    public static BertJapaneseTokenizationUpdate fromXContent(XContentParser parser) {
        return (BertJapaneseTokenizationUpdate)PARSER.apply(parser, null);
    }

    public BertJapaneseTokenizationUpdate(@Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        super(truncate, span);
    }

    public BertJapaneseTokenizationUpdate(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Tokenization apply(Tokenization originalConfig) {
        if (!(originalConfig instanceof BertJapaneseTokenization)) {
            throw ExceptionsHelper.badRequestException("Tokenization config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
        }
        Tokenization.validateSpanAndTruncate(this.getTruncate(), this.getSpan());
        if (this.isNoop()) {
            return originalConfig;
        }
        if (this.getTruncate() != null && !this.getTruncate().isInCompatibleWithSpan()) {
            return new BertJapaneseTokenization(originalConfig.doLowerCase(), originalConfig.withSpecialTokens(), originalConfig.maxSequenceLength(), this.getTruncate(), null);
        }
        return new BertJapaneseTokenization(originalConfig.doLowerCase(), originalConfig.withSpecialTokens(), originalConfig.maxSequenceLength(), Optional.ofNullable(this.getTruncate()).orElse(originalConfig.getTruncate()), Optional.ofNullable(this.getSpan()).orElse(originalConfig.getSpan()));
    }

    public String getWriteableName() {
        return BertJapaneseTokenization.NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return BertJapaneseTokenization.NAME.getPreferredName();
    }

    static {
        BertJapaneseTokenizationUpdate.declareCommonParserFields(PARSER);
    }
}

