/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.index.mapper.BlockLoader;

public class ResultBuilderForAggregateMetricDouble
implements ResultBuilder {
    private final AggregateMetricDoubleBlockBuilder builder;

    ResultBuilderForAggregateMetricDouble(BlockFactory blockFactory, int positions) {
        this.builder = blockFactory.newAggregateMetricDoubleBlockBuilder(positions);
    }

    @Override
    public void decodeKey(BytesRef keys) {
        throw new AssertionError((Object)"AggregateMetricDoubleBlock can't be a key");
    }

    @Override
    public void decodeValue(BytesRef values) {
        int count = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        if (count == 0) {
            this.builder.appendNull();
            return;
        }
        for (BlockLoader.DoubleBuilder subBuilder : List.of(this.builder.min(), this.builder.max(), this.builder.sum())) {
            if (TopNEncoder.DEFAULT_UNSORTABLE.decodeBoolean(values)) {
                subBuilder.appendDouble(TopNEncoder.DEFAULT_UNSORTABLE.decodeDouble(values));
                continue;
            }
            subBuilder.appendNull();
        }
        if (TopNEncoder.DEFAULT_UNSORTABLE.decodeBoolean(values)) {
            this.builder.count().appendInt(TopNEncoder.DEFAULT_UNSORTABLE.decodeInt(values));
        } else {
            this.builder.count().appendNull();
        }
    }

    @Override
    public Block build() {
        return this.builder.build();
    }

    public String toString() {
        return "ResultBuilderForAggregateMetricDouble";
    }

    public void close() {
        this.builder.close();
    }
}

