/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner.premapper;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryBuilderResolver;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;

public class PreMapper {
    private final TransportActionServices services;
    private final Executor searchExecutor;

    public PreMapper(TransportActionServices services) {
        this.services = services;
        this.searchExecutor = services.transportService().getThreadPool().executor("search");
    }

    public void preMapper(LogicalPlan plan, ActionListener<LogicalPlan> listener) {
        this.queryRewrite(plan, (ActionListener<LogicalPlan>)listener.delegateFailureAndWrap((l, p) -> {
            p.setOptimized();
            l.onResponse((Object)p);
        }));
    }

    private void queryRewrite(LogicalPlan plan, ActionListener<LogicalPlan> listener) {
        SubscribableListener.newForked(l -> QueryBuilderResolver.resolveQueryBuilders(plan, this.services, (ActionListener<LogicalPlan>)l)).addListener(listener, this.searchExecutor, null);
    }
}

