/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStatsFilteredAggWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferIsNotNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferNonNullAggConstraint;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.LocalPropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceFieldWithConstantOrNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceTopNWithLimitAndSort;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LocalLogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LocalLogicalOptimizerContext> {
    private static final List<RuleExecutor.Batch<LogicalPlan>> RULES = CollectionUtils.arrayAsArrayList((Object[])new RuleExecutor.Batch[]{new RuleExecutor.Batch("Local rewrite", RuleExecutor.Limiter.ONCE, new ReplaceTopNWithLimitAndSort(), new ReplaceFieldWithConstantOrNull(), new InferIsNotNull(), new InferNonNullAggConstraint()), LocalLogicalPlanOptimizer.localOperators(), LogicalPlanOptimizer.cleanup()});

    public LocalLogicalPlanOptimizer(LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        super(localLogicalOptimizerContext);
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return RULES;
    }

    private static RuleExecutor.Batch<LogicalPlan> localOperators() {
        RuleExecutor.Batch<LogicalPlan> operators = LogicalPlanOptimizer.operators(true);
        Rule<?, LogicalPlan>[] rules = operators.rules();
        ArrayList newRules = new ArrayList(rules.length);
        for (Rule<?, LogicalPlan> r : rules) {
            if (r instanceof PropagateEmptyRelation) {
                PropagateEmptyRelation ignoredPropagate = (PropagateEmptyRelation)r;
                newRules.add(new LocalPropagateEmptyRelation());
                continue;
            }
            if (r instanceof ReplaceStatsFilteredAggWithEval) continue;
            newRules.add(r);
        }
        return operators.with((Rule[])newRules.toArray(Rule[]::new));
    }

    public LogicalPlan localOptimize(LogicalPlan plan) {
        return this.execute(plan);
    }
}

