/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentBuilder;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.PlanProfile;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.esql.action.EsqlResponse;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlResponseImpl;
import org.elasticsearch.xpack.esql.action.ResponseValueUtils;
import org.elasticsearch.xpack.esql.action.ResponseXContentUtils;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class EsqlQueryResponse
extends org.elasticsearch.xpack.core.esql.action.EsqlQueryResponse
implements ChunkedToXContentObject,
Releasable {
    private final AbstractRefCounted counted = AbstractRefCounted.of(this::closeInternal);
    private static final TransportVersion ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED = TransportVersion.fromName((String)"esql_documents_found_and_values_loaded");
    private static final TransportVersion ESQL_PROFILE_INCLUDE_PLAN = TransportVersion.fromName((String)"esql_profile_include_plan");
    public static final String DROP_NULL_COLUMNS_OPTION = "drop_null_columns";
    private final List<ColumnInfoImpl> columns;
    private final List<Page> pages;
    private final long documentsFound;
    private final long valuesLoaded;
    private final Profile profile;
    private final boolean columnar;
    private final String asyncExecutionId;
    private final boolean isRunning;
    private final boolean isAsync;
    private final EsqlExecutionInfo executionInfo;
    private EsqlResponseImpl esqlResponse;

    public EsqlQueryResponse(List<ColumnInfoImpl> columns, List<Page> pages, long documentsFound, long valuesLoaded, @Nullable Profile profile, boolean columnar, @Nullable String asyncExecutionId, boolean isRunning, boolean isAsync, EsqlExecutionInfo executionInfo) {
        this.columns = columns;
        this.pages = pages;
        this.valuesLoaded = valuesLoaded;
        this.documentsFound = documentsFound;
        this.profile = profile;
        this.columnar = columnar;
        this.asyncExecutionId = asyncExecutionId;
        this.isRunning = isRunning;
        this.isAsync = isAsync;
        this.executionInfo = executionInfo;
    }

    public EsqlQueryResponse(List<ColumnInfoImpl> columns, List<Page> pages, long documentsFound, long valuesLoaded, @Nullable Profile profile, boolean columnar, boolean isAsync, EsqlExecutionInfo executionInfo) {
        this(columns, pages, documentsFound, valuesLoaded, profile, columnar, null, false, isAsync, executionInfo);
    }

    public static Writeable.Reader<EsqlQueryResponse> reader(BlockFactory blockFactory) {
        return in -> {
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                EsqlQueryResponse esqlQueryResponse = EsqlQueryResponse.deserialize(bsi);
                return esqlQueryResponse;
            }
        };
    }

    static EsqlQueryResponse deserialize(BlockStreamInput in) throws IOException {
        long valuesLoaded;
        String asyncExecutionId = null;
        boolean isRunning = false;
        boolean isAsync = false;
        Profile profile = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            asyncExecutionId = in.readOptionalString();
            isRunning = in.readBoolean();
            isAsync = in.readBoolean();
        }
        List columns = in.readCollectionAsList(ColumnInfoImpl::new);
        List pages = in.readCollectionAsList(Page::new);
        long documentsFound = in.getTransportVersion().supports(ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED) ? in.readVLong() : 0L;
        long l = valuesLoaded = in.getTransportVersion().supports(ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED) ? in.readVLong() : 0L;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            profile = (Profile)in.readOptionalWriteable(Profile::readFrom);
        }
        boolean columnar = in.readBoolean();
        EsqlExecutionInfo executionInfo = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            executionInfo = (EsqlExecutionInfo)in.readOptionalWriteable(EsqlExecutionInfo::new);
        }
        return new EsqlQueryResponse(columns, pages, documentsFound, valuesLoaded, profile, columnar, asyncExecutionId, isRunning, isAsync, executionInfo);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeOptionalString(this.asyncExecutionId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isAsync);
        }
        out.writeCollection(this.columns);
        out.writeCollection(this.pages);
        if (out.getTransportVersion().supports(ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED)) {
            out.writeVLong(this.documentsFound);
            out.writeVLong(this.valuesLoaded);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            out.writeOptionalWriteable((Writeable)this.profile);
        }
        out.writeBoolean(this.columnar);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeOptionalWriteable((Writeable)this.executionInfo);
        }
    }

    public List<ColumnInfoImpl> columns() {
        return this.columns;
    }

    List<Page> pages() {
        return this.pages;
    }

    public Iterator<Iterator<Object>> values() {
        List<DataType> dataTypes = this.columns.stream().map(ColumnInfoImpl::type).toList();
        return ResponseValueUtils.pagesToValues(dataTypes, this.pages);
    }

    public Iterable<Iterable<Object>> rows() {
        List<DataType> dataTypes = this.columns.stream().map(ColumnInfoImpl::type).toList();
        return ResponseValueUtils.valuesForRowsInPages(dataTypes, this.pages);
    }

    public Iterator<Object> column(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException();
        }
        return ResponseValueUtils.valuesForColumn(columnIndex, this.columns.get(columnIndex).type(), this.pages);
    }

    public long documentsFound() {
        return this.documentsFound;
    }

    public long valuesLoaded() {
        return this.valuesLoaded;
    }

    public Profile profile() {
        return this.profile;
    }

    public boolean columnar() {
        return this.columnar;
    }

    public Optional<String> asyncExecutionId() {
        return Optional.ofNullable(this.asyncExecutionId);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean isPartial() {
        return this.executionInfo != null && this.executionInfo.isPartial();
    }

    public EsqlExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder((ToXContent.Params)params).object(b -> {
            boolean[] nullColumns;
            boolean dropNullColumns = b.params().paramAsBoolean(DROP_NULL_COLUMNS_OPTION, false);
            boolean[] blArray = nullColumns = dropNullColumns ? this.nullColumns() : null;
            if (this.isAsync) {
                if (this.asyncExecutionId != null) {
                    b.field("id", this.asyncExecutionId);
                }
                b.field("is_running", this.isRunning);
            }
            b.field("documents_found", this.documentsFound);
            b.field("values_loaded", this.valuesLoaded);
            if (this.executionInfo != null) {
                long tookInMillis = this.executionInfo.overallTook() == null ? this.executionInfo.tookSoFar().millis() : this.executionInfo.overallTook().millis();
                b.field("took", tookInMillis);
                b.field(EsqlExecutionInfo.IS_PARTIAL_FIELD.getPreferredName(), this.executionInfo.isPartial());
            }
            if (dropNullColumns) {
                b.append(ResponseXContentUtils.allColumns(this.columns, "all_columns"));
                b.append(ResponseXContentUtils.nonNullColumns(this.columns, nullColumns, "columns"));
            } else {
                b.append(ResponseXContentUtils.allColumns(this.columns, "columns"));
            }
            b.array("values", ResponseXContentUtils.columnValues(this.columns, this.pages, this.columnar, nullColumns));
            if (this.executionInfo != null && this.executionInfo.hasMetadataToReport()) {
                b.field("_clusters", (ChunkedToXContent)this.executionInfo);
            }
            if (this.profile != null) {
                b.field("profile", p -> ChunkedToXContent.builder((ToXContent.Params)p).object(ob -> {
                    if (this.executionInfo != null) {
                        ob.field("query", (ToXContent)this.executionInfo.overallTimeSpan());
                        ob.field("planning", (ToXContent)this.executionInfo.planningTimeSpan());
                    }
                    ob.array("drivers", this.profile.drivers.iterator(), ChunkedToXContentBuilder::append);
                    ob.array("plans", this.profile.plans.iterator());
                }));
            }
        });
    }

    public boolean[] nullColumns() {
        boolean[] nullColumns = new boolean[this.columns.size()];
        for (int c = 0; c < nullColumns.length; ++c) {
            nullColumns[c] = this.allColumnsAreNull(c);
        }
        return nullColumns;
    }

    private boolean allColumnsAreNull(int c) {
        for (Page page : this.pages) {
            if (page.getBlock(c).areAllValuesNull()) continue;
            return false;
        }
        return true;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EsqlQueryResponse that = (EsqlQueryResponse)((Object)o);
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.asyncExecutionId, that.asyncExecutionId) && Objects.equals(this.isRunning, that.isRunning) && this.columnar == that.columnar && Iterators.equals(this.values(), that.values(), (row1, row2) -> Iterators.equals((Iterator)row1, (Iterator)row2, Objects::equals)) && this.documentsFound == that.documentsFound && this.valuesLoaded == that.valuesLoaded && Objects.equals(this.profile, that.profile) && Objects.equals(this.executionInfo, that.executionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.asyncExecutionId, this.isRunning, this.columns, this.columnar, Iterators.hashCode(this.values(), row -> Iterators.hashCode((Iterator)row, Objects::hashCode)), this.documentsFound, this.valuesLoaded, this.profile, this.executionInfo);
    }

    public String toString() {
        return Strings.toString((ToXContent)ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)this));
    }

    public void incRef() {
        this.tryIncRef();
    }

    public boolean tryIncRef() {
        return this.counted.tryIncRef();
    }

    public boolean decRef() {
        return this.counted.decRef();
    }

    public boolean hasReferences() {
        return this.counted.hasReferences();
    }

    public void close() {
        super.close();
        this.decRef();
        if (this.esqlResponse != null) {
            this.esqlResponse.setClosedState();
        }
    }

    void closeInternal() {
        Releasables.close(() -> Iterators.map(this.pages.iterator(), p -> () -> ((Page)p).releaseBlocks()));
    }

    public EsqlResponse responseInternal() {
        if (!this.hasReferences()) {
            throw new IllegalStateException("closed");
        }
        if (this.esqlResponse != null) {
            return this.esqlResponse;
        }
        this.esqlResponse = new EsqlResponseImpl(this);
        return this.esqlResponse;
    }

    public record Profile(List<DriverProfile> drivers, List<PlanProfile> plans) implements Writeable
    {
        public static Profile readFrom(StreamInput in) throws IOException {
            return new Profile(in.readCollectionAsImmutableList(DriverProfile::new), in.getTransportVersion().supports(ESQL_PROFILE_INCLUDE_PLAN) ? in.readCollectionAsImmutableList(PlanProfile::readFrom) : List.of());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.drivers);
            if (out.getTransportVersion().supports(ESQL_PROFILE_INCLUDE_PLAN)) {
                out.writeCollection(this.plans);
            }
        }
    }
}

