/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTask;
import software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTasksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplaceRootVolumeTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeReplaceRootVolumeTasksResponse> {
    private static final SdkField<List<ReplaceRootVolumeTask>> REPLACE_ROOT_VOLUME_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplaceRootVolumeTasks").getter(DescribeReplaceRootVolumeTasksResponse.getter(DescribeReplaceRootVolumeTasksResponse::replaceRootVolumeTasks)).setter(DescribeReplaceRootVolumeTasksResponse.setter(Builder::replaceRootVolumeTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceRootVolumeTaskSet").unmarshallLocationName("replaceRootVolumeTaskSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplaceRootVolumeTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReplaceRootVolumeTasksResponse.getter(DescribeReplaceRootVolumeTasksResponse::nextToken)).setter(DescribeReplaceRootVolumeTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACE_ROOT_VOLUME_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReplaceRootVolumeTasksResponse.memberNameToFieldInitializer();
    private final List<ReplaceRootVolumeTask> replaceRootVolumeTasks;
    private final String nextToken;

    private DescribeReplaceRootVolumeTasksResponse(BuilderImpl builder) {
        super(builder);
        this.replaceRootVolumeTasks = builder.replaceRootVolumeTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReplaceRootVolumeTasks() {
        return this.replaceRootVolumeTasks != null && !(this.replaceRootVolumeTasks instanceof SdkAutoConstructList);
    }

    public final List<ReplaceRootVolumeTask> replaceRootVolumeTasks() {
        return this.replaceRootVolumeTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplaceRootVolumeTasks() ? this.replaceRootVolumeTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplaceRootVolumeTasksResponse)) {
            return false;
        }
        DescribeReplaceRootVolumeTasksResponse other = (DescribeReplaceRootVolumeTasksResponse)((Object)obj);
        return this.hasReplaceRootVolumeTasks() == other.hasReplaceRootVolumeTasks() && Objects.equals(this.replaceRootVolumeTasks(), other.replaceRootVolumeTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReplaceRootVolumeTasksResponse").add("ReplaceRootVolumeTasks", this.hasReplaceRootVolumeTasks() ? this.replaceRootVolumeTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplaceRootVolumeTasks": {
                return Optional.ofNullable(clazz.cast(this.replaceRootVolumeTasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplaceRootVolumeTaskSet", REPLACE_ROOT_VOLUME_TASKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplaceRootVolumeTasksResponse, T> g) {
        return obj -> g.apply((DescribeReplaceRootVolumeTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ReplaceRootVolumeTask> replaceRootVolumeTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplaceRootVolumeTasksResponse model) {
            super(model);
            this.replaceRootVolumeTasks(model.replaceRootVolumeTasks);
            this.nextToken(model.nextToken);
        }

        public final List<ReplaceRootVolumeTask.Builder> getReplaceRootVolumeTasks() {
            List<ReplaceRootVolumeTask.Builder> result = ReplaceRootVolumeTasksCopier.copyToBuilder(this.replaceRootVolumeTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplaceRootVolumeTasks(Collection<ReplaceRootVolumeTask.BuilderImpl> replaceRootVolumeTasks) {
            this.replaceRootVolumeTasks = ReplaceRootVolumeTasksCopier.copyFromBuilder(replaceRootVolumeTasks);
        }

        @Override
        public final Builder replaceRootVolumeTasks(Collection<ReplaceRootVolumeTask> replaceRootVolumeTasks) {
            this.replaceRootVolumeTasks = ReplaceRootVolumeTasksCopier.copy(replaceRootVolumeTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceRootVolumeTasks(ReplaceRootVolumeTask ... replaceRootVolumeTasks) {
            this.replaceRootVolumeTasks(Arrays.asList(replaceRootVolumeTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceRootVolumeTasks(Consumer<ReplaceRootVolumeTask.Builder> ... replaceRootVolumeTasks) {
            this.replaceRootVolumeTasks(Stream.of(replaceRootVolumeTasks).map(c -> (ReplaceRootVolumeTask)((ReplaceRootVolumeTask.Builder)ReplaceRootVolumeTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeReplaceRootVolumeTasksResponse build() {
            return new DescribeReplaceRootVolumeTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplaceRootVolumeTasksResponse> {
        public Builder replaceRootVolumeTasks(Collection<ReplaceRootVolumeTask> var1);

        public Builder replaceRootVolumeTasks(ReplaceRootVolumeTask ... var1);

        public Builder replaceRootVolumeTasks(Consumer<ReplaceRootVolumeTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

