/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.smartcn;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugin.analysis.smartcn.SmartChineseAnalyzerProvider;
import org.elasticsearch.plugin.analysis.smartcn.SmartChineseNoOpTokenFilterFactory;
import org.elasticsearch.plugin.analysis.smartcn.SmartChineseStopTokenFilterFactory;
import org.elasticsearch.plugin.analysis.smartcn.SmartChineseTokenizerTokenizerFactory;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;

public class AnalysisSmartChinesePlugin
extends Plugin
implements AnalysisPlugin {
    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> tokenFilters = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        tokenFilters.put("smartcn_stop", SmartChineseStopTokenFilterFactory::new);
        tokenFilters.put("smartcn_word", SmartChineseNoOpTokenFilterFactory::new);
        return tokenFilters;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>>();
        extra.put("smartcn_tokenizer", SmartChineseTokenizerTokenizerFactory::new);
        extra.put("smartcn_sentence", SmartChineseTokenizerTokenizerFactory::new);
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        return Collections.singletonMap("smartcn", SmartChineseAnalyzerProvider::new);
    }
}

