/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.validation;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.ModelVersionProcessor;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultModelValidator
implements ModelValidator {
    private static final Pattern CI_FRIENDLY_EXPRESSION = Pattern.compile("\\$\\{(.+?)}");
    private static final Pattern EXPRESSION_PROJECT_NAME_PATTERN = Pattern.compile("\\$\\{(project.+?)}");
    private static final String ILLEGAL_FS_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "\\/:\"<>|?*";
    private static final String EMPTY = "";
    private final Set<String> validIds = new HashSet<String>();
    private ModelVersionProcessor versionProcessor;

    @Inject
    public DefaultModelValidator(ModelVersionProcessor versionProcessor) {
        this.versionProcessor = versionProcessor;
    }

    @Override
    public void validateRawModel(Model m, ModelBuildingRequest request, ModelProblemCollector problems) {
        block13: {
            Parent parent;
            block12: {
                parent = m.getParent();
                if (parent != null) {
                    this.validateStringNotEmpty("parent.groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getGroupId(), (InputLocationTracker)parent);
                    this.validateStringNotEmpty("parent.artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getArtifactId(), (InputLocationTracker)parent);
                    this.validateStringNotEmpty("parent.version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getVersion(), (InputLocationTracker)parent);
                    if (DefaultModelValidator.equals(parent.getGroupId(), m.getGroupId()) && DefaultModelValidator.equals(parent.getArtifactId(), m.getArtifactId())) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, "parent.artifactId", null, "must be changed, the parent element cannot have the same groupId:artifactId as the project.", (InputLocationTracker)parent);
                    }
                    if (DefaultModelValidator.equals("LATEST", parent.getVersion()) || DefaultModelValidator.equals("RELEASE", parent.getVersion())) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, "parent.version", null, "is either LATEST or RELEASE (both of them are being deprecated)", (InputLocationTracker)parent);
                    }
                }
                if (request.getValidationLevel() != 0) break block12;
                HashSet<String> minProfileIds = new HashSet<String>();
                for (Profile profile : m.getProfiles()) {
                    if (minProfileIds.add(profile.getId())) continue;
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, "profiles.profile.id", null, "Duplicate activation for profile " + profile.getId(), (InputLocationTracker)profile);
                }
                break block13;
            }
            if (request.getValidationLevel() < 20) break block13;
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, m.getModelVersion(), (InputLocationTracker)m);
            this.validateModelVersion(problems, m.getModelVersion(), (InputLocationTracker)m, "4.0.0");
            this.validateStringNoExpression("groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getGroupId(), (InputLocationTracker)m);
            if (parent == null) {
                this.validateStringNotEmpty("groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getGroupId(), (InputLocationTracker)m);
            }
            this.validateStringNoExpression("artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
            this.validateStringNotEmpty("artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
            this.validateVersionNoExpression("version", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getVersion(), (InputLocationTracker)m);
            if (parent == null) {
                this.validateStringNotEmpty("version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getVersion(), (InputLocationTracker)m);
            }
            this.validate20RawDependencies(problems, m.getDependencies(), "dependencies.dependency.", EMPTY, request);
            this.validate20RawDependenciesSelfReferencing(problems, m, m.getDependencies(), "dependencies.dependency", request);
            if (m.getDependencyManagement() != null) {
                this.validate20RawDependencies(problems, m.getDependencyManagement().getDependencies(), "dependencyManagement.dependencies.dependency.", EMPTY, request);
            }
            this.validateRawRepositories(problems, m.getRepositories(), "repositories.repository.", EMPTY, request);
            this.validateRawRepositories(problems, m.getPluginRepositories(), "pluginRepositories.pluginRepository.", EMPTY, request);
            Build build = m.getBuild();
            if (build != null) {
                this.validate20RawPlugins(problems, build.getPlugins(), "build.plugins.plugin.", EMPTY, request);
                PluginManagement mgmt = build.getPluginManagement();
                if (mgmt != null) {
                    this.validate20RawPlugins(problems, mgmt.getPlugins(), "build.pluginManagement.plugins.plugin.", EMPTY, request);
                }
            }
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : m.getProfiles()) {
                String prefix = "profiles.profile[" + profile.getId() + "].";
                if (!profileIds.add(profile.getId())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile.getId(), (InputLocationTracker)profile);
                }
                this.validate30RawProfileActivation(problems, profile.getActivation(), prefix);
                this.validate20RawDependencies(problems, profile.getDependencies(), prefix, "dependencies.dependency.", request);
                if (profile.getDependencyManagement() != null) {
                    this.validate20RawDependencies(problems, profile.getDependencyManagement().getDependencies(), prefix, "dependencyManagement.dependencies.dependency.", request);
                }
                this.validateRawRepositories(problems, profile.getRepositories(), prefix, "repositories.repository.", request);
                this.validateRawRepositories(problems, profile.getPluginRepositories(), prefix, "pluginRepositories.pluginRepository.", request);
                BuildBase buildBase = profile.getBuild();
                if (buildBase == null) continue;
                this.validate20RawPlugins(problems, buildBase.getPlugins(), prefix, "plugins.plugin.", request);
                PluginManagement mgmt = buildBase.getPluginManagement();
                if (mgmt == null) continue;
                this.validate20RawPlugins(problems, mgmt.getPlugins(), prefix, "pluginManagement.plugins.plugin.", request);
            }
        }
    }

    private void validate30RawProfileActivation(ModelProblemCollector problems, Activation activation, String prefix) {
        if (activation == null) {
            return;
        }
        LinkedList<ActivationFrame> stk = new LinkedList<ActivationFrame>();
        Supplier<String> pathSupplier = () -> {
            boolean parallel = false;
            return StreamSupport.stream(((Iterable)stk::descendingIterator).spliterator(), false).map(f -> f.location).collect(Collectors.joining("."));
        };
        Supplier<InputLocation> locationSupplier = () -> {
            if (stk.size() < 2) {
                return null;
            }
            Iterator f = stk.iterator();
            String location = ((ActivationFrame)f.next()).location;
            ActivationFrame parent = (ActivationFrame)f.next();
            return parent.parent.map(p -> p.getLocation((Object)location)).orElse(null);
        };
        Consumer<String> validator = s -> {
            if (this.hasProjectExpression((String)s)) {
                String path = (String)pathSupplier.get();
                Matcher matcher = EXPRESSION_PROJECT_NAME_PATTERN.matcher((CharSequence)s);
                while (matcher.find()) {
                    String propertyName = matcher.group(0);
                    if (path.startsWith("activation.file.") && "${project.basedir}".equals(propertyName)) continue;
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, prefix + path, null, "Failed to interpolate profile activation property " + s + ": " + propertyName + " expressions are not supported during profile activation.", (InputLocationTracker)locationSupplier.get());
                }
            }
        };
        Optional<Activation> root = Optional.of(activation);
        class ActivationFrame {
            String location;
            Optional<? extends InputLocationTracker> parent;

            ActivationFrame(String location, Optional<? extends InputLocationTracker> parent) {
                this.location = location;
                this.parent = parent;
            }
        }
        stk.push(new ActivationFrame("activation", root));
        root.map(Activation::getFile).ifPresent(fa -> {
            stk.push(new ActivationFrame("file", Optional.of(fa)));
            stk.push(new ActivationFrame("exists", Optional.empty()));
            validator.accept(fa.getExists());
            ((ActivationFrame)stk.peek()).location = "missing";
            validator.accept(fa.getMissing());
            stk.pop();
            stk.pop();
        });
        root.map(Activation::getOs).ifPresent(oa -> {
            stk.push(new ActivationFrame("os", Optional.of(oa)));
            stk.push(new ActivationFrame("arch", Optional.empty()));
            validator.accept(oa.getArch());
            ((ActivationFrame)stk.peek()).location = "family";
            validator.accept(oa.getFamily());
            ((ActivationFrame)stk.peek()).location = "name";
            validator.accept(oa.getName());
            ((ActivationFrame)stk.peek()).location = "version";
            validator.accept(oa.getVersion());
            stk.pop();
            stk.pop();
        });
        root.map(Activation::getProperty).ifPresent(pa -> {
            stk.push(new ActivationFrame("property", Optional.of(pa)));
            stk.push(new ActivationFrame("name", Optional.empty()));
            validator.accept(pa.getName());
            ((ActivationFrame)stk.peek()).location = "value";
            validator.accept(pa.getValue());
            stk.pop();
            stk.pop();
        });
        root.map(Activation::getJdk).ifPresent(jdk -> {
            stk.push(new ActivationFrame("jdk", Optional.empty()));
            validator.accept((String)jdk);
            stk.pop();
        });
    }

    private void validate20RawPlugins(ModelProblemCollector problems, List<Plugin> plugins, String prefix, String prefix2, ModelBuildingRequest request) {
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        HashMap<String, Plugin> index = new HashMap<String, Plugin>();
        for (Plugin plugin : plugins) {
            String key;
            Plugin existing;
            if (plugin.getGroupId() == null || plugin.getGroupId() != null && plugin.getGroupId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "groupId of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if (plugin.getArtifactId() == null || plugin.getArtifactId() != null && plugin.getArtifactId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "artifactId of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if (plugin.getVersion() != null && plugin.getVersion().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "version of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if ((existing = (Plugin)index.get(key = plugin.getKey())) != null) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "must be unique but found duplicate declaration of plugin " + key, (InputLocationTracker)plugin);
            } else {
                index.put(key, plugin);
            }
            HashSet<String> executionIds = new HashSet<String>();
            for (PluginExecution exec : plugin.getExecutions()) {
                if (executionIds.add(exec.getId())) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, prefix + prefix2 + "[" + plugin.getKey() + "].executions.execution.id", null, "must be unique but found duplicate execution with id " + exec.getId(), (InputLocationTracker)exec);
            }
        }
    }

    @Override
    public void validateEffectiveModel(Model m, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getModelVersion(), (InputLocationTracker)m);
        this.validateId("groupId", problems, m.getGroupId(), (InputLocationTracker)m);
        this.validateId("artifactId", problems, m.getArtifactId(), (InputLocationTracker)m);
        this.validateStringNotEmpty("packaging", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getPackaging(), (InputLocationTracker)m);
        if (!m.getModules().isEmpty()) {
            if (!"pom".equals(m.getPackaging())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "packaging", null, "with value '" + m.getPackaging() + "' is invalid. Aggregator projects require 'pom' as packaging.", (InputLocationTracker)m);
            }
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)m.getModules().get(i);
                if (!StringUtils.isBlank((String)module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "modules.module[" + i + "]", null, "has been specified without a path to the project directory.", (InputLocationTracker)m.getLocation((Object)"modules"));
            }
        }
        this.validateStringNotEmpty("version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getVersion(), (InputLocationTracker)m);
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        this.validateEffectiveDependencies(problems, m, m.getDependencies(), false, request);
        DependencyManagement mgmt = m.getDependencyManagement();
        if (mgmt != null) {
            this.validateEffectiveDependencies(problems, m, mgmt.getDependencies(), true, request);
        }
        if (request.getValidationLevel() >= 20) {
            Reporting reporting;
            HashSet<String> modules = new HashSet<String>();
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)m.getModules().get(i);
                if (modules.add(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "modules.module[" + i + "]", null, "specifies duplicate child module " + (String)module, (InputLocationTracker)m.getLocation((Object)"modules"));
            }
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            this.validateBannedCharacters(EMPTY, "version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, (InputLocationTracker)m, "\\/:\"<>|?*");
            this.validate20ProperSnapshotVersion("version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, (InputLocationTracker)m);
            Build build = m.getBuild();
            if (build != null) {
                for (Object p : build.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getArtifactId(), (InputLocationTracker)p);
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getGroupId(), (InputLocationTracker)p);
                    this.validate20PluginVersion("build.plugins.plugin.version", problems, p.getVersion(), p.getKey(), (InputLocationTracker)p, request);
                    this.validateBoolean("build.plugins.plugin.inherited", EMPTY, problems, errOn30, ModelProblem.Version.V20, p.getInherited(), p.getKey(), (InputLocationTracker)p);
                    this.validateBoolean("build.plugins.plugin.extensions", EMPTY, problems, errOn30, ModelProblem.Version.V20, p.getExtensions(), p.getKey(), (InputLocationTracker)p);
                    this.validate20EffectivePluginDependencies(problems, (Plugin)p, request);
                }
                this.validate20RawResources(problems, build.getResources(), "build.resources.resource.", request);
                this.validate20RawResources(problems, build.getTestResources(), "build.testResources.testResource.", request);
            }
            if ((reporting = m.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getArtifactId(), (InputLocationTracker)p);
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getGroupId(), (InputLocationTracker)p);
                }
            }
            for (Repository repository : m.getRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "repositories.repository.", request);
            }
            for (Repository repository : m.getPluginRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "pluginRepositories.pluginRepository.", request);
            }
            DistributionManagement distMgmt = m.getDistributionManagement();
            if (distMgmt != null) {
                if (distMgmt.getStatus() != null) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "distributionManagement.status", null, "must not be specified.", (InputLocationTracker)distMgmt);
                }
                this.validate20EffectiveRepository(problems, (Repository)distMgmt.getRepository(), "distributionManagement.repository.", request);
                this.validate20EffectiveRepository(problems, (Repository)distMgmt.getSnapshotRepository(), "distributionManagement.snapshotRepository.", request);
            }
        }
    }

    private void validate20RawDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, String prefix2, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            Dependency existing;
            String key = dependency.getManagementKey();
            if ("import".equals(dependency.getScope())) {
                if (!"pom".equals(dependency.getType())) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "type", key, "must be 'pom' to import the managed dependencies.", (InputLocationTracker)dependency);
                } else if (StringUtils.isNotEmpty((String)dependency.getClassifier())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "classifier", key, "must be empty, imported POM cannot have a classifier.", (InputLocationTracker)dependency);
                }
            } else if ("system".equals(dependency.getScope())) {
                String sysPath;
                if (request.getValidationLevel() >= 31) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V31, prefix + prefix2 + "scope", key, "declares usage of deprecated 'system' scope ", (InputLocationTracker)dependency);
                }
                if (StringUtils.isNotEmpty((String)(sysPath = dependency.getSystemPath()))) {
                    if (!this.hasExpression(sysPath)) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", key, "should use a variable instead of a hard-coded path " + sysPath, (InputLocationTracker)dependency);
                    } else if (sysPath.contains("${basedir}") || sysPath.contains("${project.basedir}")) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", key, "should not point at files within the project directory, " + sysPath + " will be unresolvable by dependent projects", (InputLocationTracker)dependency);
                    }
                }
            }
            if (DefaultModelValidator.equals("LATEST", dependency.getVersion()) || DefaultModelValidator.equals("RELEASE", dependency.getVersion())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + prefix2 + "version", key, "is either LATEST or RELEASE (both of them are being deprecated)", (InputLocationTracker)dependency);
            }
            if ((existing = (Dependency)index.get(key)) != null) {
                String msg = DefaultModelValidator.equals(existing.getVersion(), dependency.getVersion()) ? "duplicate declaration of version " + Objects.toString(dependency.getVersion(), "(?)") : "version " + Objects.toString(existing.getVersion(), "(?)") + " vs " + Objects.toString(dependency.getVersion(), "(?)");
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId:type:classifier)", null, "must be unique: " + key + " -> " + msg, (InputLocationTracker)dependency);
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validate20RawDependenciesSelfReferencing(ModelProblemCollector problems, Model m, List<Dependency> dependencies, String prefix, ModelBuildingRequest request) {
        for (Dependency dependency : dependencies) {
            String mKey;
            String key = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + (dependency.getClassifier() != null ? ":" + dependency.getClassifier() : EMPTY);
            if (!key.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) continue;
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key + "]", key, "is referencing itself.", (InputLocationTracker)dependency);
        }
    }

    private void validateEffectiveDependencies(ModelProblemCollector problems, Model m, List<Dependency> dependencies, boolean management, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        String prefix = management ? "dependencyManagement.dependencies.dependency." : "dependencies.dependency.";
        for (Dependency d : dependencies) {
            this.validateEffectiveDependency(problems, d, management, prefix, request);
            if (request.getValidationLevel() < 20) continue;
            this.validateBoolean(prefix, "optional", problems, errOn30, ModelProblem.Version.V20, d.getOptional(), d.getManagementKey(), (InputLocationTracker)d);
            if (!management) {
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.V20, d.getVersion(), d.getManagementKey(), (InputLocationTracker)d);
                this.validateEnum(prefix, "scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), d.getManagementKey(), (InputLocationTracker)d, "provided", "compile", "runtime", "test", "system");
                this.validateEffectiveModelAgainstDependency(prefix, problems, m, d, request);
                continue;
            }
            this.validateEnum(prefix, "scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), d.getManagementKey(), (InputLocationTracker)d, "provided", "compile", "runtime", "test", "system", "import");
        }
    }

    private void validateEffectiveModelAgainstDependency(String prefix, ModelProblemCollector problems, Model m, Dependency d, ModelBuildingRequest request) {
        String mKey;
        String key = d.getGroupId() + ":" + d.getArtifactId() + ":" + d.getVersion() + (d.getClassifier() != null ? ":" + d.getClassifier() : EMPTY);
        if (key.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key + "]", key, "is referencing itself.", (InputLocationTracker)d);
        }
    }

    private void validate20EffectivePluginDependencies(ModelProblemCollector problems, Plugin plugin, ModelBuildingRequest request) {
        List dependencies = plugin.getDependencies();
        if (!dependencies.isEmpty()) {
            String prefix = "build.plugins.plugin[" + plugin.getKey() + "].dependencies.dependency.";
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            for (Dependency d : dependencies) {
                this.validateEffectiveDependency(problems, d, false, prefix, request);
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.BASE, d.getVersion(), d.getManagementKey(), (InputLocationTracker)d);
                this.validateEnum(prefix, "scope", problems, errOn30, ModelProblem.Version.BASE, d.getScope(), d.getManagementKey(), (InputLocationTracker)d, "compile", "runtime", "system");
            }
        }
    }

    private void validateEffectiveDependency(ModelProblemCollector problems, Dependency d, boolean management, String prefix, ModelBuildingRequest request) {
        this.validateId(prefix, "artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getArtifactId(), d.getManagementKey(), (InputLocationTracker)d);
        this.validateId(prefix, "groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getGroupId(), d.getManagementKey(), (InputLocationTracker)d);
        if (!management) {
            this.validateStringNotEmpty(prefix, "type", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getType(), d.getManagementKey(), (InputLocationTracker)d);
            this.validateDependencyVersion(problems, d, prefix);
        }
        if ("system".equals(d.getScope())) {
            String systemPath = d.getSystemPath();
            if (StringUtils.isEmpty((String)systemPath)) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), "is missing.", (InputLocationTracker)d);
            } else {
                File sysFile = new File(systemPath);
                if (!sysFile.isAbsolute()) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), "must specify an absolute path but is " + systemPath, (InputLocationTracker)d);
                } else if (!sysFile.isFile()) {
                    String jdkHome;
                    String msg = "refers to a non-existing file " + sysFile.getAbsolutePath();
                    if ((systemPath = systemPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(jdkHome = request.getSystemProperties().getProperty("java.home", EMPTY) + File.separator + "..")) {
                        msg = msg + ". Please verify that you run Maven using a JDK and not just a JRE.";
                    }
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), msg, (InputLocationTracker)d);
                }
            }
        } else if (StringUtils.isNotEmpty((String)d.getSystemPath())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), "must be omitted. This field may only be specified for a dependency with system scope.", (InputLocationTracker)d);
        }
        if (request.getValidationLevel() >= 20) {
            for (Exclusion exclusion : d.getExclusions()) {
                if (request.getValidationLevel() < 30) {
                    this.validateId(prefix, "exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getGroupId(), d.getManagementKey(), (InputLocationTracker)exclusion);
                    this.validateId(prefix, "exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getArtifactId(), d.getManagementKey(), (InputLocationTracker)exclusion);
                    continue;
                }
                this.validateIdWithWildcards(prefix, "exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getGroupId(), d.getManagementKey(), (InputLocationTracker)exclusion);
                this.validateIdWithWildcards(prefix, "exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getArtifactId(), d.getManagementKey(), (InputLocationTracker)exclusion);
            }
        }
    }

    protected void validateDependencyVersion(ModelProblemCollector problems, Dependency d, String prefix) {
        this.validateStringNotEmpty(prefix, "version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getVersion(), d.getManagementKey(), (InputLocationTracker)d);
    }

    private void validateRawRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, String prefix2, ModelBuildingRequest request) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(prefix, prefix2, "id", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getId(), null, (InputLocationTracker)repository);
            this.validateStringNotEmpty(prefix, prefix2, "[" + repository.getId() + "].url", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getUrl(), null, (InputLocationTracker)repository);
            String key = repository.getId();
            Repository existing = (Repository)index.get(key);
            if (existing != null) {
                ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
                DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "id", null, "must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl(), (InputLocationTracker)repository);
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validate20EffectiveRepository(ModelProblemCollector problems, Repository repository, String prefix, ModelBuildingRequest request) {
        if (repository != null) {
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            this.validateBannedCharacters(prefix, "id", problems, errOn31, ModelProblem.Version.V20, repository.getId(), null, (InputLocationTracker)repository, "\\/:\"<>|?*");
            if ("local".equals(repository.getId())) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + "id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.", (InputLocationTracker)repository);
            }
            if ("legacy".equals(repository.getLayout())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + "layout", repository.getId(), "uses the unsupported value 'legacy', artifact resolution might fail.", (InputLocationTracker)repository);
            }
        }
    }

    private void validate20RawResources(ModelProblemCollector problems, List<Resource> resources, String prefix, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix, "directory", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, resource.getDirectory(), null, (InputLocationTracker)resource);
            this.validateBoolean(prefix, "filtering", problems, errOn30, ModelProblem.Version.V20, resource.getFiltering(), resource.getDirectory(), (InputLocationTracker)resource);
        }
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id, InputLocationTracker tracker) {
        return this.validateId(EMPTY, fieldName, problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, id, null, tracker);
    }

    private boolean validateId(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (this.validIds.contains(id)) {
            return true;
        }
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidId(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid id pattern.", tracker);
            return false;
        }
        this.validIds.add(id);
        return true;
    }

    private boolean isValidId(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidIdCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIdCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.';
    }

    private boolean validateIdWithWildcards(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidIdWithWildCards(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid id pattern.", tracker);
            return false;
        }
        return true;
    }

    private boolean isValidIdWithWildCards(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidIdWithWildCardCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIdWithWildCardCharacter(char c) {
        return this.isValidIdCharacter(c) || c == '?' || c == '*';
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
        return false;
    }

    private boolean validateVersionNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        Matcher m = CI_FRIENDLY_EXPRESSION.matcher(string.trim());
        while (m.find()) {
            String property = m.group(1);
            if (this.versionProcessor.isValidProperty(property)) continue;
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
            return false;
        }
        return true;
    }

    private boolean hasExpression(String value) {
        return value != null && value.contains("${");
    }

    private boolean hasProjectExpression(String value) {
        return value != null && value.contains("${project.");
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        return this.validateStringNotEmpty(EMPTY, fieldName, problems, severity, version, string, null, tracker);
    }

    private boolean validateStringNotEmpty(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, prefix2, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateStringNotEmpty(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateBoolean(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be 'true' or 'false' but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateEnum(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String ... validValues) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values = Arrays.asList(validValues);
        if (values.contains(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be one of " + values + " but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateModelVersion(ModelProblemCollector problems, String string, InputLocationTracker tracker, String ... validVersions) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        List<String> values = Arrays.asList(validVersions);
        if (values.contains(string)) {
            return true;
        }
        boolean newerThanAll = true;
        boolean olderThanAll = true;
        for (String validValue : validVersions) {
            int comparison = DefaultModelValidator.compareModelVersions(validValue, string);
            newerThanAll = newerThanAll && comparison < 0;
            olderThanAll = olderThanAll && comparison > 0;
        }
        if (newerThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is newer than the versions supported by this version of Maven: " + values + ". Building this project requires a newer version of Maven.", tracker);
        } else if (olderThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is older than the versions supported by this version of Maven: " + values + ". Building this project requires an older version of Maven.", tracker);
        } else {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "modelVersion", null, "must be one of " + values + " but is '" + string + "'.", tracker);
        }
        return false;
    }

    private static int compareModelVersions(String first, String second) {
        String[] firstSegments = StringUtils.split((String)first, (String)".");
        String[] secondSegments = StringUtils.split((String)second, (String)".");
        for (int i = 0; i < Math.max(firstSegments.length, secondSegments.length); ++i) {
            int result = Long.valueOf(i < firstSegments.length ? firstSegments[i] : "0").compareTo(Long.valueOf(i < secondSegments.length ? secondSegments[i] : "0"));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private boolean validateBannedCharacters(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String banned) {
        if (string != null) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string.charAt(i)) < 0) continue;
                DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must not contain any of these characters " + banned + " but found " + string.charAt(i), tracker);
                return false;
            }
        }
        return true;
    }

    private boolean validateVersion(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (this.hasExpression(string)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return this.validateBannedCharacters(prefix, fieldName, problems, severity, version, string, sourceHint, tracker, "\\/:\"<>|?*");
    }

    private boolean validate20ProperSnapshotVersion(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if (string.endsWith("SNAPSHOT") && !string.endsWith("-SNAPSHOT")) {
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, sourceHint, "uses an unsupported snapshot version format, should be '*-SNAPSHOT' instead.", tracker);
            return false;
        }
        return true;
    }

    private boolean validate20PluginVersion(String fieldName, ModelProblemCollector problems, String string, String sourceHint, InputLocationTracker tracker, ModelBuildingRequest request) {
        if (string == null) {
            return true;
        }
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        if (!this.validateVersion(EMPTY, fieldName, problems, errOn30, ModelProblem.Version.V20, string, sourceHint, tracker)) {
            return false;
        }
        if (string.length() <= 0 || "RELEASE".equals(string) || "LATEST".equals(string)) {
            DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return true;
    }

    private static void addViolation(ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String fieldName, String sourceHint, String message, InputLocationTracker tracker) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append(" for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        problems.add(new ModelProblemCollectorRequest(severity, version).setMessage(buffer.toString()).setLocation(DefaultModelValidator.getLocation(fieldName, tracker)));
    }

    private static InputLocation getLocation(String fieldName, InputLocationTracker tracker) {
        InputLocation location = null;
        if (tracker != null) {
            if (fieldName != null) {
                Object key = fieldName;
                int idx = fieldName.lastIndexOf(46);
                if (idx >= 0) {
                    fieldName = fieldName.substring(idx + 1);
                    key = fieldName;
                }
                if (fieldName.endsWith("]")) {
                    key = fieldName.substring(fieldName.lastIndexOf(91) + 1, fieldName.length() - 1);
                    try {
                        key = Integer.valueOf(key.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                location = tracker.getLocation(key);
            }
            if (location == null) {
                location = tracker.getLocation((Object)EMPTY);
            }
        }
        return location;
    }

    private static boolean equals(String s1, String s2) {
        return StringUtils.clean((String)s1).equals(StringUtils.clean((String)s2));
    }

    private static ModelProblem.Severity getSeverity(ModelBuildingRequest request, int errorThreshold) {
        return DefaultModelValidator.getSeverity(request.getValidationLevel(), errorThreshold);
    }

    private static ModelProblem.Severity getSeverity(int validationLevel, int errorThreshold) {
        if (validationLevel < errorThreshold) {
            return ModelProblem.Severity.WARNING;
        }
        return ModelProblem.Severity.ERROR;
    }
}

