/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchAuthenticationProcessingError;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.support.Exceptions;

public class DefaultAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private volatile Map<String, List<String>> defaultFailureResponseHeaders;

    public DefaultAuthenticationFailureHandler(Map<String, List<String>> failureResponseHeaders) {
        this.defaultFailureResponseHeaders = failureResponseHeaders == null || failureResponseHeaders.isEmpty() ? Collections.singletonMap("WWW-Authenticate", Collections.singletonList("Basic realm=\"security\", charset=\"UTF-8\"")) : Collections.unmodifiableMap(failureResponseHeaders.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            if (((String)entry.getKey()).equalsIgnoreCase("WWW-Authenticate")) {
                ArrayList<String> values = new ArrayList<String>((Collection)entry.getValue());
                values.sort(Comparator.comparing(DefaultAuthenticationFailureHandler::authSchemePriority));
                return Collections.unmodifiableList(values);
            }
            return Collections.unmodifiableList((List)entry.getValue());
        })));
    }

    public void setHeaders(Map<String, List<String>> failureResponseHeaders) {
        this.defaultFailureResponseHeaders = failureResponseHeaders;
    }

    private static Integer authSchemePriority(String headerValue) {
        if (headerValue.regionMatches(true, 0, "negotiate", 0, "negotiate".length())) {
            return 0;
        }
        if (headerValue.regionMatches(true, 0, "bearer", 0, "bearer".length())) {
            return 1;
        }
        if (headerValue.regionMatches(true, 0, "apikey", 0, "apikey".length())) {
            return 2;
        }
        if (headerValue.regionMatches(true, 0, "basic", 0, "basic".length())) {
            return 3;
        }
        return 4;
    }

    @Override
    public ElasticsearchSecurityException failedAuthentication(HttpPreRequest request, AuthenticationToken token, ThreadContext context) {
        return this.createAuthenticationError("unable to authenticate user [{}] for REST request [{}]", null, token.principal(), request.uri());
    }

    @Override
    public ElasticsearchSecurityException failedAuthentication(TransportRequest message, AuthenticationToken token, String action, ThreadContext context) {
        return this.createAuthenticationError("unable to authenticate user [{}] for action [{}]", null, token.principal(), action);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(HttpPreRequest request, Exception e, ThreadContext context) {
        if (e instanceof ElasticsearchAuthenticationProcessingError) {
            return (ElasticsearchAuthenticationProcessingError)e;
        }
        return this.createAuthenticationError("error attempting to authenticate request", e, null);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(TransportRequest message, String action, Exception e, ThreadContext context) {
        if (e instanceof ElasticsearchAuthenticationProcessingError) {
            return (ElasticsearchAuthenticationProcessingError)e;
        }
        return this.createAuthenticationError("error attempting to authenticate request", e, null);
    }

    @Override
    public ElasticsearchSecurityException missingToken(HttpPreRequest request, ThreadContext context) {
        return this.createAuthenticationError("missing authentication credentials for REST request [{}]", null, request.uri());
    }

    @Override
    public ElasticsearchSecurityException missingToken(TransportRequest message, String action, ThreadContext context) {
        return this.createAuthenticationError("missing authentication credentials for action [{}]", null, action);
    }

    @Override
    public ElasticsearchSecurityException authenticationRequired(String action, ThreadContext context) {
        return this.createAuthenticationError("action [{}] requires authentication", null, action);
    }

    private ElasticsearchSecurityException createAuthenticationError(String message, Throwable t, Object ... args) {
        boolean containsNegotiateWithToken;
        ElasticsearchSecurityException ese;
        if (t instanceof ElasticsearchSecurityException) {
            assert (((ElasticsearchSecurityException)t).status() == RestStatus.UNAUTHORIZED);
            ese = (ElasticsearchSecurityException)t;
            containsNegotiateWithToken = ese.getHeader("WWW-Authenticate") != null && !ese.getHeader("WWW-Authenticate").isEmpty() ? ese.getHeader("WWW-Authenticate").stream().anyMatch(s -> s != null && s.regionMatches(true, 0, "Negotiate ", 0, "Negotiate ".length())) : false;
        } else {
            ese = Exceptions.authenticationError(message, t, args);
            containsNegotiateWithToken = false;
        }
        this.defaultFailureResponseHeaders.forEach((key, value) -> {
            if (containsNegotiateWithToken && key.equalsIgnoreCase("WWW-Authenticate")) {
                return;
            }
            ese.addHeader((String)key, (List<String>)value);
        });
        return ese;
    }
}

