/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;

public class EvaluateDataFrameAction
extends ActionType<Response> {
    public static final EvaluateDataFrameAction INSTANCE = new EvaluateDataFrameAction();
    public static final String NAME = "cluster:monitor/xpack/ml/data_frame/evaluate";

    private EvaluateDataFrameAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final String evaluationName;
        private final List<EvaluationMetricResult> metrics;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.evaluationName = in.readString();
            this.metrics = in.readNamedWriteableCollectionAsList(EvaluationMetricResult.class);
        }

        public Response(String evaluationName, List<EvaluationMetricResult> metrics) {
            this.evaluationName = Objects.requireNonNull(evaluationName);
            this.metrics = Objects.requireNonNull(metrics);
        }

        public String getEvaluationName() {
            return this.evaluationName;
        }

        public List<EvaluationMetricResult> getMetrics() {
            return this.metrics;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.evaluationName);
            out.writeNamedWriteableCollection(this.metrics);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject(this.evaluationName);
            for (EvaluationMetricResult metric : this.metrics) {
                builder.field(metric.getMetricName(), metric);
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.evaluationName, this.metrics);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.evaluationName, other.evaluationName) && Objects.equals(this.metrics, other.metrics);
        }

        public final String toString() {
            return Strings.toString(this);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private static final ParseField INDEX = new ParseField("index", new String[0]);
        private static final ParseField QUERY = new ParseField("query", new String[0]);
        private static final ParseField EVALUATION = new ParseField("evaluation", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("cluster:monitor/xpack/ml/data_frame/evaluate", a -> new Request((List)a[0], (QueryProvider)a[1], (Evaluation)a[2]));
        private String[] indices;
        private QueryProvider queryProvider;
        private Evaluation evaluation;

        private static Evaluation parseEvaluation(XContentParser parser) throws IOException {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
            Evaluation evaluation = parser.namedObject(Evaluation.class, parser.currentName(), null);
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
            return evaluation;
        }

        public static Request parseRequest(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        private Request(List<String> indices, @Nullable QueryProvider queryProvider, Evaluation evaluation) {
            this.setIndices(indices);
            this.setQueryProvider(queryProvider);
            this.setEvaluation(evaluation);
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
            if (in.readBoolean()) {
                this.queryProvider = QueryProvider.fromStream(in);
            }
            this.evaluation = in.readNamedWriteable(Evaluation.class);
        }

        public String[] getIndices() {
            return this.indices;
        }

        public final Request setIndices(List<String> indices) {
            ExceptionsHelper.requireNonNull(indices, INDEX);
            if (indices.isEmpty()) {
                throw ExceptionsHelper.badRequestException("At least one index must be specified", new Object[0]);
            }
            this.indices = indices.toArray(new String[indices.size()]);
            return this;
        }

        public QueryBuilder getParsedQuery() {
            return Optional.ofNullable(this.queryProvider).orElseGet(QueryProvider::defaultQuery).getParsedQuery();
        }

        public final Request setQueryProvider(QueryProvider queryProvider) {
            this.queryProvider = queryProvider;
            return this;
        }

        public Evaluation getEvaluation() {
            return this.evaluation;
        }

        public final Request setEvaluation(Evaluation evaluation) {
            this.evaluation = ExceptionsHelper.requireNonNull(evaluation, EVALUATION);
            return this;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
            if (this.queryProvider != null) {
                out.writeBoolean(true);
                this.queryProvider.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            out.writeNamedWriteable(this.evaluation);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.array(INDEX.getPreferredName(), this.indices);
            if (this.queryProvider != null) {
                builder.field(QUERY.getPreferredName(), this.queryProvider.getQuery());
            }
            builder.startObject(EVALUATION.getPreferredName()).field(this.evaluation.getName(), this.evaluation).endObject();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.queryProvider, this.evaluation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Arrays.equals(this.indices, that.indices) && Objects.equals(this.queryProvider, that.queryProvider) && Objects.equals(this.evaluation, that.evaluation);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "evaluate_data_frame", parentTaskId, headers);
        }

        static {
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryProvider.fromXContent(p, true, "Data Frame Analytics config query is not parsable"), QUERY);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Request.parseEvaluation(p), EVALUATION);
        }
    }
}

