/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ReservedStateErrorMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ReservedStateChunk;
import org.elasticsearch.reservedstate.service.ReservedStateErrorTask;
import org.elasticsearch.reservedstate.service.ReservedStateErrorTaskExecutor;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTask;
import org.elasticsearch.reservedstate.service.ReservedStateUpdateTaskExecutor;
import org.elasticsearch.reservedstate.service.ReservedStateVersion;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class ReservedClusterStateService {
    private static final Logger logger = LogManager.getLogger(ReservedClusterStateService.class);
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("metadata", new String[0]);
    final Map<String, ReservedClusterStateHandler<?>> handlers;
    final ClusterService clusterService;
    private final MasterServiceTaskQueue<ReservedStateUpdateTask> updateTaskQueue;
    private final MasterServiceTaskQueue<ReservedStateErrorTask> errorTaskQueue;
    private final ConstructingObjectParser<ReservedStateChunk, Void> stateChunkParser = new ConstructingObjectParser("reserved_state_chunk", a -> {
        List tuples = (List)a[0];
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        for (Tuple tuple : tuples) {
            stateMap.put((String)tuple.v1(), tuple.v2());
        }
        return new ReservedStateChunk(stateMap, (ReservedStateVersion)a[1]);
    });

    public ReservedClusterStateService(ClusterService clusterService, RerouteService rerouteService, List<ReservedClusterStateHandler<?>> handlerList) {
        this.clusterService = clusterService;
        this.updateTaskQueue = clusterService.createTaskQueue("reserved state update", Priority.URGENT, new ReservedStateUpdateTaskExecutor(rerouteService));
        this.errorTaskQueue = clusterService.createTaskQueue("reserved state error", Priority.URGENT, new ReservedStateErrorTaskExecutor());
        this.handlers = handlerList.stream().collect(Collectors.toMap(ReservedClusterStateHandler::name, Function.identity()));
        this.stateChunkParser.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, name) -> {
            if (!this.handlers.containsKey(name)) {
                throw new IllegalStateException("Missing handler definition for content key [" + name + "]");
            }
            p.nextToken();
            return new Tuple(name, this.handlers.get(name).fromXContent(p));
        }, STATE_FIELD);
        this.stateChunkParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ReservedStateVersion.parse(p), METADATA_FIELD);
    }

    ReservedStateChunk parse(String namespace, XContentParser parser) {
        try {
            return this.stateChunkParser.apply(parser, null);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, ReservedStateMetadata.EMPTY_VERSION, ReservedStateVersionCheck.HIGHER_VERSION_ONLY, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            throw new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState), e);
        }
    }

    public void process(String namespace, XContentParser parser, ReservedStateVersionCheck versionCheck, Consumer<Exception> errorListener) {
        ReservedStateChunk stateChunk;
        try {
            stateChunk = this.parse(namespace, parser);
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, ReservedStateMetadata.EMPTY_VERSION, versionCheck, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState), e));
            return;
        }
        this.process(namespace, stateChunk, versionCheck, errorListener);
    }

    public void initEmpty(String namespace, ActionListener<ActionResponse.Empty> listener) {
        ReservedStateVersion missingVersion = new ReservedStateVersion(ReservedStateMetadata.EMPTY_VERSION, Version.CURRENT);
        ReservedStateChunk emptyState = new ReservedStateChunk(Map.of(), missingVersion);
        this.updateTaskQueue.submitTask("empty initial cluster state [" + namespace + "]", new ReservedStateUpdateTask(namespace, emptyState, ReservedStateVersionCheck.HIGHER_VERSION_ONLY, Map.of(), List.of(), errorState -> {
            throw new AssertionError();
        }, listener), null);
    }

    public void process(final String namespace, ReservedStateChunk reservedStateChunk, final ReservedStateVersionCheck versionCheck, final Consumer<Exception> errorListener) {
        LinkedHashSet<String> orderedHandlers;
        Map<String, Object> reservedState = reservedStateChunk.state();
        final ReservedStateVersion reservedStateVersion = reservedStateChunk.metadata();
        try {
            orderedHandlers = this.orderedStateHandlers(reservedState.keySet());
        }
        catch (Exception e) {
            ErrorState errorState = new ErrorState(namespace, reservedStateVersion.version(), versionCheck, e, ReservedStateErrorMetadata.ErrorKind.PARSING);
            this.updateErrorState(errorState);
            logger.debug("error processing state change request for [{}] with the following errors [{}]", (Object)namespace, (Object)errorState);
            errorListener.accept(new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState), e));
            return;
        }
        ClusterState state = this.clusterService.state();
        final ReservedStateMetadata existingMetadata = state.metadata().reservedStateMetadata().get(namespace);
        if (!ReservedStateUpdateTask.checkMetadataVersion(namespace, existingMetadata, reservedStateVersion, versionCheck)) {
            errorListener.accept(null);
            return;
        }
        List<String> trialRunErrors = this.trialRun(namespace, state, reservedStateChunk, orderedHandlers);
        Exception error = this.checkAndReportError(namespace, trialRunErrors, reservedStateVersion, versionCheck);
        if (error != null) {
            errorListener.accept(error);
            return;
        }
        this.updateTaskQueue.submitTask("reserved cluster state [" + namespace + "]", new ReservedStateUpdateTask(namespace, reservedStateChunk, versionCheck, this.handlers, orderedHandlers, this::updateErrorState, new ActionListener<ActionResponse.Empty>(){

            @Override
            public void onResponse(ActionResponse.Empty empty) {
                logger.info("Successfully applied new reserved cluster state for namespace [{}]", (Object)namespace);
                errorListener.accept(null);
            }

            @Override
            public void onFailure(Exception e) {
                if (ReservedStateErrorTask.isNewError(existingMetadata, reservedStateVersion.version(), versionCheck)) {
                    logger.debug("Failed to apply reserved cluster state", (Throwable)e);
                    errorListener.accept(e);
                } else {
                    errorListener.accept(null);
                }
            }
        }), null);
    }

    Exception checkAndReportError(String namespace, List<String> errors, ReservedStateVersion reservedStateVersion, ReservedStateVersionCheck versionCheck) {
        if (!errors.isEmpty()) {
            logger.debug("Error processing state change request for [{}] with the following errors [{}]", (Object)namespace, errors);
            ErrorState errorState = new ErrorState(namespace, reservedStateVersion.version(), versionCheck, errors, ReservedStateErrorMetadata.ErrorKind.VALIDATION);
            this.updateErrorState(errorState);
            return new IllegalStateException("Error processing state change request for " + namespace + ", errors: " + String.valueOf(errorState));
        }
        return null;
    }

    void updateErrorState(ErrorState errorState) {
        if (!ReservedStateErrorTask.checkErrorVersion(this.clusterService.state(), errorState)) {
            return;
        }
        this.submitErrorUpdateTask(errorState);
    }

    private void submitErrorUpdateTask(final ErrorState errorState) {
        this.errorTaskQueue.submitTask("reserved cluster state update error for [ " + errorState.namespace() + "]", new ReservedStateErrorTask(errorState, new ActionListener<ActionResponse.Empty>(){

            @Override
            public void onResponse(ActionResponse.Empty empty) {
                logger.info("Successfully applied new reserved error state for namespace [{}]", (Object)errorState.namespace());
            }

            @Override
            public void onFailure(Exception e) {
                logger.error("Failed to apply reserved error cluster state", (Throwable)e);
            }
        }), null);
    }

    List<String> trialRun(String namespace, ClusterState currentState, ReservedStateChunk stateChunk, LinkedHashSet<String> orderedHandlers) {
        ReservedStateMetadata existingMetadata = currentState.metadata().reservedStateMetadata().get(namespace);
        Map<String, Object> reservedState = stateChunk.state();
        ArrayList<String> errors = new ArrayList<String>();
        ClusterState state = currentState;
        for (String handlerName : orderedHandlers) {
            ReservedClusterStateHandler<?> handler = this.handlers.get(handlerName);
            try {
                Set<String> existingKeys = ReservedStateUpdateTask.keysForHandler(existingMetadata, handlerName);
                TransformState transformState = handler.transform(reservedState.get(handlerName), new TransformState(state, existingKeys));
                state = transformState.state();
            }
            catch (Exception e) {
                errors.add(Strings.format("Error processing %s state change: %s", handler.name(), ExceptionsHelper.stackTrace(e)));
            }
        }
        return errors;
    }

    LinkedHashSet<String> orderedStateHandlers(Set<String> handlerNames) {
        LinkedHashSet<String> orderedHandlers = new LinkedHashSet<String>();
        LinkedHashSet<String> dependencyStack = new LinkedHashSet<String>();
        for (String key : handlerNames) {
            this.addStateHandler(key, handlerNames, orderedHandlers, dependencyStack);
        }
        return orderedHandlers;
    }

    private void addStateHandler(String key, Set<String> keys, LinkedHashSet<String> ordered, LinkedHashSet<String> visited) {
        if (visited.contains(key)) {
            StringBuilder msg = new StringBuilder("Cycle found in settings dependencies: ");
            visited.forEach(s -> {
                msg.append((String)s);
                msg.append(" -> ");
            });
            msg.append(key);
            throw new IllegalStateException(msg.toString());
        }
        if (ordered.contains(key)) {
            return;
        }
        visited.add(key);
        ReservedClusterStateHandler<?> handler = this.handlers.get(key);
        if (handler == null) {
            throw new IllegalStateException("Unknown handler type: " + key);
        }
        for (String dependency : handler.dependencies()) {
            if (!keys.contains(dependency)) {
                throw new IllegalStateException("Missing handler dependency definition: " + key + " -> " + dependency);
            }
            this.addStateHandler(dependency, keys, ordered, visited);
        }
        for (String dependency : handler.optionalDependencies()) {
            if (!keys.contains(dependency)) continue;
            this.addStateHandler(dependency, keys, ordered, visited);
        }
        visited.remove(key);
        ordered.add(key);
    }

    public void installStateHandler(ReservedClusterStateHandler<?> handler) {
        this.handlers.put(handler.name(), handler);
    }
}

