/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import co.elastic.clients.ApiClient;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;

public class Version {
    private final int major;
    private final int minor;
    private final int maintenance;
    private final String prerelease;
    private final String build;
    @Nullable
    public static final Version VERSION;

    public static Version parse(String version) {
        int plus;
        String prerelease = null;
        String build = null;
        int hyphen = version.indexOf(45);
        if (hyphen >= 0) {
            prerelease = version.substring(hyphen + 1);
            version = version.substring(0, hyphen);
            plus = prerelease.indexOf(43);
            if (plus >= 0) {
                build = prerelease.substring(0, plus + 1);
                prerelease = prerelease.substring(0, plus);
            }
        }
        if ((plus = version.indexOf(43)) >= 0) {
            build = version.substring(0, plus + 1);
            version = version.substring(0, plus);
        }
        String[] bits = version.split("\\.");
        try {
            int major = bits.length >= 1 ? Integer.parseInt(bits[0]) : 0;
            int minor = bits.length >= 2 ? Integer.parseInt(bits[1]) : 0;
            int maintenance = bits.length >= 3 ? Integer.parseInt(bits[2]) : -1;
            return new Version(major, minor, maintenance, prerelease, build);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Version(int major, int minor, int maintenance, boolean isPreRelease) {
        this(major, minor, maintenance, isPreRelease ? "p" : null, null);
    }

    public Version(int major, int minor, int maintenance, @Nullable String prerelease, @Nullable String build) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.prerelease = prerelease;
        this.build = build;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int maintenance() {
        return this.maintenance;
    }

    public boolean isPreRelease() {
        return this.prerelease != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version that = (Version)other;
        return this.major == that.major && this.minor == that.minor && this.maintenance == that.maintenance && Objects.equals(this.prerelease, that.prerelease) && Objects.equals(this.build, that.build);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.maintenance, this.prerelease, this.build);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.major);
        s.append('.');
        s.append(this.minor);
        if (this.maintenance != -1) {
            s.append('.');
            s.append(this.maintenance);
        }
        if (this.prerelease != null) {
            s.append('-').append(this.prerelease);
        }
        if (this.build != null) {
            s.append('+').append(this.build);
        }
        return s.toString();
    }

    static {
        Version version = null;
        InputStream in = ApiClient.class.getResourceAsStream("version.properties");
        if (in != null) {
            Properties properties = new Properties();
            try {
                properties.load(in);
                String versionStr = properties.getProperty("version");
                if (versionStr != null) {
                    version = Version.parse(versionStr);
                }
            }
            catch (Exception e) {
                version = Version.parse("8.18.3");
            }
        }
        VERSION = version;
    }
}

