/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.document;

public enum DocumentKind {
    ODT("application/vnd.oasis.opendocument.text"),
    ODS("application/vnd.oasis.opendocument.spreadsheet"),
    ODP("application/vnd.oasis.opendocument.presentation"),
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation");

    private final String mimeType;

    private DocumentKind(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static DocumentKind fromMimeType(String mimetype) {
        DocumentKind[] kinds = DocumentKind.values();
        DocumentKind documentKind = null;
        for (int i = 0; i < kinds.length; ++i) {
            documentKind = kinds[i];
            if (!mimetype.startsWith(documentKind.getMimeType())) continue;
            return documentKind;
        }
        return null;
    }
}

