/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToDouble
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToDouble", ToDouble::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.DOUBLE, (source, fieldEval) -> fieldEval), Map.entry(DataType.BOOLEAN, ToDoubleFromBooleanEvaluator.Factory::new), Map.entry(DataType.DATETIME, ToDoubleFromLongEvaluator.Factory::new), Map.entry(DataType.KEYWORD, ToDoubleFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToDoubleFromStringEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToDoubleFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.LONG, ToDoubleFromLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToDoubleFromIntEvaluator.Factory::new), Map.entry(DataType.COUNTER_DOUBLE, (source, field) -> field), Map.entry(DataType.COUNTER_INTEGER, ToDoubleFromIntEvaluator.Factory::new), Map.entry(DataType.COUNTER_LONG, ToDoubleFromLongEvaluator.Factory::new));

    @FunctionInfo(returnType={"double"}, description="Converts an input value to a double value. If the input parameter is of a date type,\nits value will be interpreted as milliseconds since the {wikipedia}/Unix_time[Unix epoch],\nconverted to double. Boolean *true* will be converted to double *1.0*, *false* to *0.0*.", examples={@Example(file="floats", tag="to_double-str", explanation="Note that in this example, the last conversion of the string isn't possible.\nWhen this happens, the result is a *null* value. In this case a _Warning_ header is added to the response.\nThe header will provide information on the source of the failure:\n\n`\"Line 1:115: evaluation of [TO_DOUBLE(str2)] failed, treating result as null. Only first 20 failures recorded.\"`\n\nA following header will contain the failure reason and the offending value:\n`\"java.lang.NumberFormatException: For input string: \"foo\"\"`")})
    public ToDouble(Source source, @Param(name="field", type={"boolean", "date", "keyword", "text", "double", "long", "unsigned_long", "integer", "counter_double", "counter_integer", "counter_long"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToDouble(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToDouble.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDouble(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDouble::new, (Object)this.field());
    }

    static double fromBoolean(boolean bool) {
        return bool ? 1.0 : 0.0;
    }

    static double fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToDouble(in.utf8ToString());
    }

    static double fromUnsignedLong(long l) {
        return EsqlDataTypeConverter.unsignedLongToDouble(l);
    }

    static double fromLong(long l) {
        return l;
    }

    static double fromInt(int i) {
        return i;
    }
}

