/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockUtils {
    public static TransportService setupTransportServiceWithThreadpoolExecutor() {
        return MockUtils.setMockReturns((TransportService)Mockito.mock(TransportService.class), (ThreadPool)Mockito.mock(ThreadPool.class));
    }

    public static TransportService setupTransportServiceWithThreadpoolExecutor(ThreadPool threadPool) {
        return MockUtils.setMockReturns((TransportService)Mockito.mock(TransportService.class), threadPool);
    }

    private static TransportService setMockReturns(TransportService transportService, ThreadPool threadPool) {
        assert (Mockito.mockingDetails((Object)threadPool).isMock());
        assert (Mockito.mockingDetails((Object)transportService).isMock());
        Mockito.when((Object)transportService.getThreadPool()).thenReturn((Object)threadPool);
        Mockito.when((Object)threadPool.executor(ArgumentMatchers.anyString())).thenReturn((Object)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        Mockito.when((Object)threadPool.generic()).thenReturn((Object)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        return transportService;
    }
}

