/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.TransportPutStoredScriptAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.script.StoredScriptSource;
import org.elasticsearch.xcontent.XContentType;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutStoredScriptAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_scripts/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/_scripts/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/_scripts/{id}/{context}"), new RestHandler.Route(RestRequest.Method.PUT, "/_scripts/{id}/{context}"));
    }

    @Override
    public String getName() {
        return "put_stored_script_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ReleasableBytesReference content = request.requiredContent();
        XContentType xContentType = request.getXContentType();
        PutStoredScriptRequest putRequest = new PutStoredScriptRequest(RestUtils.getMasterNodeTimeout(request), RestUtils.getAckTimeout(request), request.param("id"), request.param("context"), content, request.getXContentType(), StoredScriptSource.parse(content, xContentType));
        return channel -> client.execute(TransportPutStoredScriptAction.TYPE, putRequest, ActionListener.withRef(new RestToXContentListener((RestChannel)channel), content));
    }
}

