/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public abstract class GeneratePluginPropertiesTask
extends DefaultTask {
    public static final String PROPERTIES_FILENAME = "plugin-descriptor.properties";
    public static final String STABLE_PROPERTIES_FILENAME = "stable-plugin-descriptor.properties";
    private static final String DESCRIPTION = "Generates Elasticsearch Plugin descriptor file";

    @Inject
    public GeneratePluginPropertiesTask(ProjectLayout projectLayout) {
        this.setDescription(DESCRIPTION);
    }

    @Input
    public abstract Property<String> getPluginName();

    @Input
    public abstract Property<String> getPluginDescription();

    @Input
    public abstract Property<String> getPluginVersion();

    @Input
    public abstract Property<String> getElasticsearchVersion();

    @Input
    public abstract Property<String> getJavaVersion();

    @Input
    @Optional
    public abstract Property<String> getClassname();

    @Input
    public abstract ListProperty<String> getExtendedPlugins();

    @Input
    public abstract Property<Boolean> getHasNativeController();

    @Input
    public abstract Property<Boolean> getRequiresKeystore();

    @Input
    public abstract Property<Boolean> getIsLicensed();

    @InputFiles
    public abstract ConfigurableFileCollection getModuleInfoFile();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    public abstract Property<Boolean> getIsStable();

    @TaskAction
    public void generatePropertiesFile() throws IOException {
        String classname = (String)this.getClassname().getOrElse((Object)"");
        boolean stablePlugin = (Boolean)this.getIsStable().getOrElse((Object)false);
        if (!stablePlugin && classname.isEmpty()) {
            throw new InvalidUserDataException("classname is a required setting for esplugin");
        }
        if (stablePlugin && !classname.isEmpty()) {
            throw new InvalidUserDataException("classname is a forbidden for stable esplugin");
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", this.getPluginName().get());
        props.put("description", this.getPluginDescription().get());
        props.put("version", this.getPluginVersion().get());
        props.put("elasticsearchVersion", this.getElasticsearchVersion().get());
        props.put("javaVersion", this.getJavaVersion().get());
        props.put("classname", classname);
        props.put("extendedPlugins", String.join((CharSequence)",", (Iterable)this.getExtendedPlugins().get()));
        props.put("hasNativeController", this.getHasNativeController().get());
        props.put("requiresKeystore", this.getRequiresKeystore().get());
        props.put("licensed", this.getIsLicensed().get());
        props.put("modulename", this.findModuleName());
        SimpleTemplateEngine engine = new SimpleTemplateEngine();
        Path outputFile = ((RegularFile)this.getOutputFile().get()).getAsFile().toPath();
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        try (InputStream inputStream = GeneratePluginPropertiesTask.class.getResourceAsStream("/plugin-descriptor.properties");
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
             BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            Template template = engine.createTemplate((Reader)reader);
            template.make(props).writeTo((Writer)writer);
        }
    }

    private String findModuleName() {
        if (this.getModuleInfoFile().isEmpty()) {
            return "";
        }
        Path moduleInfoSource = this.getModuleInfoFile().getSingleFile().toPath();
        ClassNode visitor = new ClassNode();
        try (InputStream inputStream = Files.newInputStream(moduleInfoSource, new OpenOption[0]);){
            new ClassReader(inputStream).accept((ClassVisitor)visitor, 0);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return visitor.module.name;
    }
}

