/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration;

public class DescribeVerifiedAccessInstanceLoggingConfigurationsIterable
implements SdkIterable<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> {
    private final Ec2Client client;
    private final DescribeVerifiedAccessInstanceLoggingConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVerifiedAccessInstanceLoggingConfigurationsIterable(Ec2Client client, DescribeVerifiedAccessInstanceLoggingConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVerifiedAccessInstanceLoggingConfigurationsResponseFetcher();
    }

    public Iterator<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VerifiedAccessInstanceLoggingConfiguration> loggingConfigurations() {
        Function<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.loggingConfigurations() != null) {
                return response.loggingConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVerifiedAccessInstanceLoggingConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> {
        private DescribeVerifiedAccessInstanceLoggingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVerifiedAccessInstanceLoggingConfigurationsResponse nextPage(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessInstanceLoggingConfigurationsIterable.this.client.describeVerifiedAccessInstanceLoggingConfigurations(DescribeVerifiedAccessInstanceLoggingConfigurationsIterable.this.firstRequest);
            }
            return DescribeVerifiedAccessInstanceLoggingConfigurationsIterable.this.client.describeVerifiedAccessInstanceLoggingConfigurations((DescribeVerifiedAccessInstanceLoggingConfigurationsRequest)((Object)DescribeVerifiedAccessInstanceLoggingConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

