/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.store;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.secret.SecretIdentifier;
import org.logstash.secret.store.SecretStore;
import org.logstash.secret.store.SecretStoreException;
import org.logstash.secret.store.SecureConfig;

public class SecretStoreFactory {
    private final EnvironmentVariableProvider environmentVariableProvider;
    public static final String KEYSTORE_ACCESS_KEY = "keystore.pass";
    public static final SecretIdentifier LOGSTASH_MARKER = new SecretIdentifier("keystore.seed");
    public static final String ENVIRONMENT_PASS_KEY = "LOGSTASH_KEYSTORE_PASS";
    private static final Logger LOGGER = LogManager.getLogger(SecretStoreFactory.class);

    public static SecretStoreFactory fromEnvironment() {
        return new SecretStoreFactory(System::getenv);
    }

    public static SecretStoreFactory withEnvironment(Map<String, String> environmentVariables) {
        return new SecretStoreFactory(environmentVariables::get);
    }

    private SecretStoreFactory(EnvironmentVariableProvider environmentVariableProvider) {
        this.environmentVariableProvider = environmentVariableProvider;
    }

    public boolean exists(SecureConfig secureConfig) {
        return this.doIt(MODE.EXISTS, secureConfig).exists(secureConfig);
    }

    public SecretStore create(SecureConfig secureConfig) {
        return this.doIt(MODE.CREATE, secureConfig);
    }

    public void delete(SecureConfig secureConfig) {
        this.doIt(MODE.DELETE, secureConfig);
    }

    public SecretStore load(SecureConfig secureConfig) {
        return this.doIt(MODE.LOAD, secureConfig);
    }

    private SecretStore doIt(MODE mode, SecureConfig secureConfig) {
        char[] configuredClassName = secureConfig.getPlainText("keystore.classname");
        String className = configuredClassName != null ? new String(configuredClassName) : "org.logstash.secret.store.backend.JavaKeyStore";
        try {
            LOGGER.debug("Attempting to {} or secret store with implementation: {}", (Object)mode.name().toLowerCase(), (Object)className);
            Class<?> implementation = Class.forName(className);
            this.addSecretStoreAccess(secureConfig);
            if (MODE.LOAD.equals((Object)mode)) {
                return ((SecretStore)implementation.getConstructor(new Class[0]).newInstance(new Object[0])).load(secureConfig);
            }
            if (MODE.CREATE.equals((Object)mode)) {
                return ((SecretStore)implementation.getConstructor(new Class[0]).newInstance(new Object[0])).create(secureConfig);
            }
            if (MODE.DELETE.equals((Object)mode)) {
                ((SecretStore)implementation.getConstructor(new Class[0]).newInstance(new Object[0])).delete(secureConfig);
                return null;
            }
            if (MODE.EXISTS.equals((Object)mode)) {
                return (SecretStore)implementation.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            throw new IllegalStateException("missing mode. This is bug in Logstash.");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SecretStoreException.ImplementationNotFoundException(String.format("Could not %s class %s, please validate the `keystore.classname` is configured correctly and that the class can be loaded by Logstash ", mode.name().toLowerCase(), className), e);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new SecretStoreException.ImplementationInvalidException(String.format("Could not %s class %s, please validate the `keystore.classname` is configured correctly and that the class can be loaded by Logstash ", mode.name().toLowerCase(), className), e);
        }
    }

    private void addSecretStoreAccess(SecureConfig secureConfig) {
        String keystore_pass = this.environmentVariableProvider.get(ENVIRONMENT_PASS_KEY);
        if (keystore_pass != null) {
            secureConfig.add(KEYSTORE_ACCESS_KEY, keystore_pass.toCharArray());
            keystore_pass = null;
        }
    }

    @FunctionalInterface
    public static interface EnvironmentVariableProvider {
        public String get(String var1);
    }

    private static enum MODE {
        LOAD,
        CREATE,
        EXISTS,
        DELETE;

    }
}

