/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalGeoBounds;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;

public final class GeoShapeBoundsAggregator
extends MetricsAggregator {
    private final GeoShapeValuesSource valuesSource;
    private final boolean wrapLongitude;
    private DoubleArray tops;
    private DoubleArray bottoms;
    private DoubleArray posLefts;
    private DoubleArray posRights;
    private DoubleArray negLefts;
    private DoubleArray negRights;

    public GeoShapeBoundsAggregator(String name, AggregationContext context, Aggregator parent, ValuesSourceConfig valuesSourceConfig, boolean wrapLongitude, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (GeoShapeValuesSource)valuesSourceConfig.getValuesSource();
        this.wrapLongitude = wrapLongitude;
        this.tops = this.bigArrays().newDoubleArray(1L, false);
        this.tops.fill(0L, this.tops.size(), Double.NEGATIVE_INFINITY);
        this.bottoms = this.bigArrays().newDoubleArray(1L, false);
        this.bottoms.fill(0L, this.bottoms.size(), Double.POSITIVE_INFINITY);
        this.posLefts = this.bigArrays().newDoubleArray(1L, false);
        this.posLefts.fill(0L, this.posLefts.size(), Double.POSITIVE_INFINITY);
        this.posRights = this.bigArrays().newDoubleArray(1L, false);
        this.posRights.fill(0L, this.posRights.size(), Double.NEGATIVE_INFINITY);
        this.negLefts = this.bigArrays().newDoubleArray(1L, false);
        this.negLefts.fill(0L, this.negLefts.size(), Double.POSITIVE_INFINITY);
        this.negRights = this.bigArrays().newDoubleArray(1L, false);
        this.negRights.fill(0L, this.negRights.size(), Double.NEGATIVE_INFINITY);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
        final GeoShapeValues values = (GeoShapeValues)this.valuesSource.shapeValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    this.maybeResize(bucket);
                    GeoShapeValues.GeoShapeValue value = (GeoShapeValues.GeoShapeValue)values.value();
                    ShapeValues.BoundingBox bounds = value.boundingBox();
                    GeoShapeBoundsAggregator.this.tops.set(bucket, Math.max(GeoShapeBoundsAggregator.this.tops.get(bucket), bounds.top));
                    GeoShapeBoundsAggregator.this.bottoms.set(bucket, Math.min(GeoShapeBoundsAggregator.this.bottoms.get(bucket), bounds.bottom));
                    GeoShapeBoundsAggregator.this.posLefts.set(bucket, Math.min(GeoShapeBoundsAggregator.this.posLefts.get(bucket), bounds.posLeft));
                    GeoShapeBoundsAggregator.this.posRights.set(bucket, Math.max(GeoShapeBoundsAggregator.this.posRights.get(bucket), bounds.posRight));
                    GeoShapeBoundsAggregator.this.negLefts.set(bucket, Math.min(GeoShapeBoundsAggregator.this.negLefts.get(bucket), bounds.negLeft));
                    GeoShapeBoundsAggregator.this.negRights.set(bucket, Math.max(GeoShapeBoundsAggregator.this.negRights.get(bucket), bounds.negRight));
                }
            }

            private void maybeResize(long bucket) {
                if (bucket >= GeoShapeBoundsAggregator.this.tops.size()) {
                    long from = GeoShapeBoundsAggregator.this.tops.size();
                    GeoShapeBoundsAggregator.this.tops = GeoShapeBoundsAggregator.this.bigArrays().grow(GeoShapeBoundsAggregator.this.tops, bucket + 1L);
                    GeoShapeBoundsAggregator.this.tops.fill(from, GeoShapeBoundsAggregator.this.tops.size(), Double.NEGATIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.bottoms = GeoShapeBoundsAggregator.this.bigArrays().resize(GeoShapeBoundsAggregator.this.bottoms, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.bottoms.fill(from, GeoShapeBoundsAggregator.this.bottoms.size(), Double.POSITIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.posLefts = GeoShapeBoundsAggregator.this.bigArrays().resize(GeoShapeBoundsAggregator.this.posLefts, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.posLefts.fill(from, GeoShapeBoundsAggregator.this.posLefts.size(), Double.POSITIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.posRights = GeoShapeBoundsAggregator.this.bigArrays().resize(GeoShapeBoundsAggregator.this.posRights, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.posRights.fill(from, GeoShapeBoundsAggregator.this.posRights.size(), Double.NEGATIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.negLefts = GeoShapeBoundsAggregator.this.bigArrays().resize(GeoShapeBoundsAggregator.this.negLefts, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.negLefts.fill(from, GeoShapeBoundsAggregator.this.negLefts.size(), Double.POSITIVE_INFINITY);
                    GeoShapeBoundsAggregator.this.negRights = GeoShapeBoundsAggregator.this.bigArrays().resize(GeoShapeBoundsAggregator.this.negRights, GeoShapeBoundsAggregator.this.tops.size());
                    GeoShapeBoundsAggregator.this.negRights.fill(from, GeoShapeBoundsAggregator.this.negRights.size(), Double.NEGATIVE_INFINITY);
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        double top = this.tops.get(owningBucketOrdinal);
        double bottom = this.bottoms.get(owningBucketOrdinal);
        double posLeft = this.posLefts.get(owningBucketOrdinal);
        double posRight = this.posRights.get(owningBucketOrdinal);
        double negLeft = this.negLefts.get(owningBucketOrdinal);
        double negRight = this.negRights.get(owningBucketOrdinal);
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalGeoBounds.empty(this.name, this.wrapLongitude, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.tops, this.bottoms, this.posLefts, this.posRights, this.negLefts, this.negRights);
    }
}

