/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.lucene.spatial.DimensionalShapeType;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.fielddata.CartesianShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.InternalCartesianCentroid;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianShapeValuesSource;

public final class CartesianShapeCentroidAggregator
extends MetricsAggregator {
    private final CartesianShapeValuesSource valuesSource;
    private DoubleArray lonSum;
    private DoubleArray lonCompensations;
    private DoubleArray latSum;
    private DoubleArray latCompensations;
    private DoubleArray weightSum;
    private DoubleArray weightCompensations;
    private LongArray counts;
    private ByteArray dimensionalShapeTypes;

    public CartesianShapeCentroidAggregator(String name, AggregationContext context, Aggregator parent, ValuesSourceConfig valuesSourceConfig, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (CartesianShapeValuesSource)valuesSourceConfig.getValuesSource();
        this.lonSum = this.bigArrays().newDoubleArray(1L, true);
        this.lonCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.latSum = this.bigArrays().newDoubleArray(1L, true);
        this.latCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.weightSum = this.bigArrays().newDoubleArray(1L, true);
        this.weightCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.counts = this.bigArrays().newLongArray(1L, true);
        this.dimensionalShapeTypes = this.bigArrays().newByteArray(1L, true);
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
        final CartesianShapeValues values = (CartesianShapeValues)this.valuesSource.shapeValues(aggCtx.getLeafReaderContext());
        final CompensatedSum compensatedSumLat = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumLon = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumWeight = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    this.maybeResize(bucket);
                    CartesianShapeCentroidAggregator.this.counts.increment(bucket, 1L);
                    DimensionalShapeType shapeType = DimensionalShapeType.fromOrdinalByte(CartesianShapeCentroidAggregator.this.dimensionalShapeTypes.get(bucket));
                    CartesianShapeValues.CartesianShapeValue value = (CartesianShapeValues.CartesianShapeValue)values.value();
                    int compares = shapeType.compareTo(value.dimensionalShapeType());
                    if (compares < 0) {
                        double coordinateWeight = value.weight();
                        compensatedSumLat.reset(coordinateWeight * value.getY(), 0.0);
                        compensatedSumLon.reset(coordinateWeight * value.getX(), 0.0);
                        compensatedSumWeight.reset(coordinateWeight, 0.0);
                        CartesianShapeCentroidAggregator.this.dimensionalShapeTypes.set(bucket, (byte)value.dimensionalShapeType().ordinal());
                    } else if (compares == 0) {
                        compensatedSumLat.reset(CartesianShapeCentroidAggregator.this.latSum.get(bucket), CartesianShapeCentroidAggregator.this.latCompensations.get(bucket));
                        compensatedSumLon.reset(CartesianShapeCentroidAggregator.this.lonSum.get(bucket), CartesianShapeCentroidAggregator.this.lonCompensations.get(bucket));
                        compensatedSumWeight.reset(CartesianShapeCentroidAggregator.this.weightSum.get(bucket), CartesianShapeCentroidAggregator.this.weightCompensations.get(bucket));
                        double coordinateWeight = value.weight();
                        compensatedSumLat.add(coordinateWeight * value.getY());
                        compensatedSumLon.add(coordinateWeight * value.getX());
                        compensatedSumWeight.add(coordinateWeight);
                    } else {
                        return;
                    }
                    CartesianShapeCentroidAggregator.this.lonSum.set(bucket, compensatedSumLon.value());
                    CartesianShapeCentroidAggregator.this.lonCompensations.set(bucket, compensatedSumLon.delta());
                    CartesianShapeCentroidAggregator.this.latSum.set(bucket, compensatedSumLat.value());
                    CartesianShapeCentroidAggregator.this.latCompensations.set(bucket, compensatedSumLat.delta());
                    CartesianShapeCentroidAggregator.this.weightSum.set(bucket, compensatedSumWeight.value());
                    CartesianShapeCentroidAggregator.this.weightCompensations.set(bucket, compensatedSumWeight.delta());
                }
            }

            private void maybeResize(long bucket) {
                CartesianShapeCentroidAggregator.this.latSum = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.latSum, bucket + 1L);
                CartesianShapeCentroidAggregator.this.lonSum = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.lonSum, bucket + 1L);
                CartesianShapeCentroidAggregator.this.weightSum = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.weightSum, bucket + 1L);
                CartesianShapeCentroidAggregator.this.lonCompensations = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.lonCompensations, bucket + 1L);
                CartesianShapeCentroidAggregator.this.latCompensations = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.latCompensations, bucket + 1L);
                CartesianShapeCentroidAggregator.this.weightCompensations = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.weightCompensations, bucket + 1L);
                CartesianShapeCentroidAggregator.this.counts = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.counts, bucket + 1L);
                CartesianShapeCentroidAggregator.this.dimensionalShapeTypes = CartesianShapeCentroidAggregator.this.bigArrays().grow(CartesianShapeCentroidAggregator.this.dimensionalShapeTypes, bucket + 1L);
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        double bucketWeight = this.weightSum.get(bucket);
        CartesianPoint bucketCentroid = bucketWeight > 0.0 ? new CartesianPoint(this.lonSum.get(bucket) / bucketWeight, this.latSum.get(bucket) / bucketWeight) : null;
        return new InternalCartesianCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalGeoCentroid.empty(this.name, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.latSum, this.latCompensations, this.lonSum, this.lonCompensations, this.counts, this.weightSum, this.weightCompensations, this.dimensionalShapeTypes);
    }
}

