/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.util.function.LongConsumer;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.h3.H3;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.spatial.common.H3SphericalUtil;

public class GeoHexCellIdSource
extends CellIdSource {
    public GeoHexCellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox, LongConsumer circuitBreakerConsumer) {
        super(valuesSource, precision, geoBoundingBox, circuitBreakerConsumer);
    }

    @Override
    protected NumericDocValues unboundedCellSingleValue(GeoPointValues values) {
        return new CellIdSource.CellSingleValue(values, this.precision()){

            @Override
            protected boolean advance(GeoPoint target) {
                this.value = H3.geoToH3((double)target.getLat(), (double)target.getLon(), (int)this.precision);
                return true;
            }
        };
    }

    @Override
    protected NumericDocValues boundedCellSingleValue(GeoPointValues values, GeoBoundingBox boundingBox) {
        final GeoHexPredicate predicate = new GeoHexPredicate(boundingBox);
        return new CellIdSource.CellSingleValue(values, this.precision()){

            @Override
            protected boolean advance(GeoPoint target) {
                double lat = target.getLat();
                double lon = target.getLon();
                long hex = H3.geoToH3((double)lat, (double)lon, (int)this.precision);
                if (GeoHexCellIdSource.this.pointInBounds(lon, lat) || predicate.validHex(hex)) {
                    assert (predicate.validHex(hex)) : H3.h3ToString((long)hex) + " should be valid but it is not";
                    this.value = hex;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected SortedNumericDocValues unboundedCellMultiValues(MultiGeoPointValues values) {
        return new CellIdSource.CellMultiValues(values, this.precision(), this.circuitBreakerConsumer){

            @Override
            protected int advanceValue(GeoPoint target, int valuesIdx) {
                this.values[valuesIdx] = H3.geoToH3((double)target.getLat(), (double)target.getLon(), (int)this.precision);
                return valuesIdx + 1;
            }
        };
    }

    @Override
    protected SortedNumericDocValues boundedCellMultiValues(MultiGeoPointValues values, GeoBoundingBox boundingBox) {
        final GeoHexPredicate predicate = new GeoHexPredicate(boundingBox);
        return new CellIdSource.CellMultiValues(values, this.precision(), this.circuitBreakerConsumer){

            @Override
            protected int advanceValue(GeoPoint target, int valuesIdx) {
                double lat = target.getLat();
                double lon = target.getLon();
                long hex = H3.geoToH3((double)lat, (double)lon, (int)this.precision);
                if (GeoHexCellIdSource.this.pointInBounds(lon, lat) || predicate.validHex(hex)) {
                    this.values[valuesIdx] = hex;
                    return valuesIdx + 1;
                }
                return valuesIdx;
            }
        };
    }

    private static class GeoHexPredicate {
        private final boolean crossesDateline;
        private final GeoBoundingBox bbox;
        private final GeoBoundingBox scratch;

        GeoHexPredicate(GeoBoundingBox bbox) {
            this.crossesDateline = bbox.right() < bbox.left();
            this.bbox = bbox;
            this.scratch = new GeoBoundingBox(new GeoPoint(), new GeoPoint());
        }

        public boolean validHex(long hex) {
            H3SphericalUtil.computeGeoBounds(hex, this.scratch);
            if (this.bbox.top() > this.scratch.bottom() && this.bbox.bottom() < this.scratch.top()) {
                if (this.scratch.left() > this.scratch.right()) {
                    return this.intersects(-180.0, this.scratch.right()) || this.intersects(this.scratch.left(), 180.0);
                }
                return this.intersects(this.scratch.left(), this.scratch.right());
            }
            return false;
        }

        private boolean intersects(double minLon, double maxLon) {
            if (this.crossesDateline) {
                return this.bbox.left() < maxLon || this.bbox.right() > minLon;
            }
            return this.bbox.left() < maxLon && this.bbox.right() > minLon;
        }
    }
}

