/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;

public class CartesianBoundingBox
extends BoundingBox<CartesianPoint> {
    public static final ParseField X_FIELD = new ParseField("x", new String[0]);
    public static final ParseField Y_FIELD = new ParseField("y", new String[0]);

    public CartesianBoundingBox(CartesianPoint topLeft, CartesianPoint bottomRight) {
        super(topLeft, bottomRight);
    }

    public CartesianBoundingBox(StreamInput input) throws IOException {
        super(new CartesianPoint(input.readDouble(), input.readDouble()), new CartesianPoint(input.readDouble(), input.readDouble()));
    }

    @Override
    public XContentBuilder toXContentFragment(XContentBuilder builder) throws IOException {
        builder.startObject(TOP_LEFT_FIELD.getPreferredName());
        builder.field(X_FIELD.getPreferredName(), ((CartesianPoint)this.topLeft).getX());
        builder.field(Y_FIELD.getPreferredName(), ((CartesianPoint)this.topLeft).getY());
        builder.endObject();
        builder.startObject(BOTTOM_RIGHT_FIELD.getPreferredName());
        builder.field(X_FIELD.getPreferredName(), ((CartesianPoint)this.bottomRight).getX());
        builder.field(Y_FIELD.getPreferredName(), ((CartesianPoint)this.bottomRight).getY());
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(((CartesianPoint)this.topLeft).getX());
        out.writeDouble(((CartesianPoint)this.topLeft).getY());
        out.writeDouble(((CartesianPoint)this.bottomRight).getX());
        out.writeDouble(((CartesianPoint)this.bottomRight).getY());
    }

    @Override
    public final String getWriteableName() {
        return "CartesianBoundingBox";
    }

    @Override
    public final TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_11_X;
    }
}

