/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class WatcherMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "watcher";
    private final boolean manuallyStopped;

    public WatcherMetadata(boolean manuallyStopped) {
        this.manuallyStopped = manuallyStopped;
    }

    public boolean manuallyStopped() {
        return this.manuallyStopped;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY);
    }

    public WatcherMetadata(StreamInput streamInput) throws IOException {
        this(streamInput.readBoolean());
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput streamInput) throws IOException {
        return WatcherMetadata.readDiffFrom(Metadata.Custom.class, TYPE, streamInput);
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeBoolean(this.manuallyStopped);
    }

    public String toString() {
        return "manuallyStopped[" + this.manuallyStopped + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatcherMetadata action = (WatcherMetadata)o;
        return this.manuallyStopped == action.manuallyStopped;
    }

    public int hashCode() {
        return Objects.hash(this.manuallyStopped);
    }

    public static Metadata.Custom fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Boolean manuallyStopped = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    break;
                }
                case VALUE_BOOLEAN: {
                    if (!Field.MANUALLY_STOPPED.match(currentFieldName, parser.getDeprecationHandler())) break;
                    manuallyStopped = parser.booleanValue();
                }
            }
        }
        if (manuallyStopped != null) {
            return new WatcherMetadata(manuallyStopped);
        }
        return null;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return ChunkedToXContentHelper.field(Field.MANUALLY_STOPPED.getPreferredName(), this.manuallyStopped);
    }

    static interface Field {
        public static final ParseField MANUALLY_STOPPED = new ParseField("manually_stopped", new String[0]);
    }
}

