/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;

public class SLMFeatureSetUsage
extends XPackFeatureUsage {
    @Nullable
    private final SnapshotLifecycleStats slmStats;

    public SLMFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.slmStats = in.readOptionalWriteable(SnapshotLifecycleStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.slmStats);
    }

    public SLMFeatureSetUsage(@Nullable SnapshotLifecycleStats slmStats) {
        super("slm", true, true);
        this.slmStats = slmStats;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_5_0;
    }

    public SnapshotLifecycleStats getStats() {
        return this.slmStats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.slmStats != null) {
            builder.field("policy_count", this.slmStats.getMetrics().size());
            builder.field("policy_stats", this.slmStats);
        }
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.slmStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLMFeatureSetUsage other = (SLMFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.slmStats, other.slmStats);
    }
}

