/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;

public record RealmDomain(String name, Set<RealmConfig.RealmIdentifier> realms) implements Writeable,
ToXContentObject
{
    public static ConstructingObjectParser<RealmDomain, Void> REALM_DOMAIN_PARSER = new ConstructingObjectParser<RealmDomain, Void>("realm_domain", false, (args, v) -> new RealmDomain((String)args[0], Set.copyOf((List)args[1])));

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeCollection(this.realms);
    }

    static RealmDomain readFrom(StreamInput in) throws IOException {
        String domainName = in.readString();
        Set<RealmConfig.RealmIdentifier> realms = in.readCollectionAsSet(RealmConfig.RealmIdentifier::new);
        return new RealmDomain(domainName, realms);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.xContentList("realms", this.realms.stream().sorted().toList());
        builder.endObject();
        return builder;
    }

    public static RealmDomain fromXContent(XContentParser parser) {
        return REALM_DOMAIN_PARSER.apply(parser, null);
    }

    @Override
    public String toString() {
        return "RealmDomain{name='" + this.name + "', realms=" + String.valueOf(this.realms) + "}";
    }

    static {
        REALM_DOMAIN_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        REALM_DOMAIN_PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> RealmConfig.REALM_IDENTIFIER_PARSER.parse(p, (Void)c), new ParseField("realms", new String[0]));
    }
}

