/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SetProfileEnabledRequest
extends LegacyActionRequest {
    private final String uid;
    private final boolean enabled;
    private final WriteRequest.RefreshPolicy refreshPolicy;

    public SetProfileEnabledRequest(String uid, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy) {
        this.uid = uid;
        this.enabled = enabled;
        this.refreshPolicy = refreshPolicy;
    }

    public SetProfileEnabledRequest(StreamInput in) throws IOException {
        super(in);
        this.uid = in.readString();
        this.enabled = in.readBoolean();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.uid);
        out.writeBoolean(this.enabled);
        this.refreshPolicy.writeTo(out);
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

