/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xcontent.XContentParser;

public final class MlParserUtils {
    private MlParserUtils() {
    }

    public static <T> List<List<T>> parseArrayOfArrays(String fieldName, CheckedFunction<XContentParser, T, IOException> valueParser, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new IllegalArgumentException("unexpected token [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
        }
        ArrayList<List<T>> values = new ArrayList<List<T>>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new IllegalArgumentException("unexpected token [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
            }
            ArrayList<T> innerList = new ArrayList<T>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (!parser.currentToken().isValue()) {
                    throw new IllegalStateException("expected non-null value but got [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
                }
                innerList.add(valueParser.apply(parser));
            }
            values.add(innerList);
        }
        return values;
    }

    public static double[][][] parse3DArrayOfDoubles(String fieldName, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new IllegalArgumentException("unexpected token [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
        }
        ArrayList values = new ArrayList();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new IllegalArgumentException("unexpected token [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
            }
            ArrayList innerList = new ArrayList();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                    throw new IllegalArgumentException("unexpected token [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
                }
                if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                    throw new IllegalArgumentException("unexpected token [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
                }
                ArrayList<Double> innerInner = new ArrayList<Double>();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
                        throw new IllegalStateException("expected non-null numerical value but got [" + String.valueOf((Object)parser.currentToken()) + "] for [" + fieldName + "]");
                    }
                    innerInner.add(parser.doubleValue());
                }
                innerList.add(innerInner);
            }
            values.add(innerList);
        }
        double[][][] val = new double[values.size()][((List)values.get(0)).size()][((List)((List)values.get(0)).get(0)).size()];
        for (int i = 0; i < val.length; ++i) {
            for (int j = 0; j < val[0].length; ++j) {
                double[] doubles = ((List)((List)values.get(i)).get(j)).stream().mapToDouble(d -> d).toArray();
                System.arraycopy(doubles, 0, val[i][j], 0, doubles.length);
            }
        }
        return val;
    }
}

