/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateJobAction
extends ActionType<PutJobAction.Response> {
    public static final UpdateJobAction INSTANCE = new UpdateJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/update";

    private UpdateJobAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private String jobId;
        private JobUpdate update;
        private boolean isInternal;

        public static Request parseRequest(String jobId, XContentParser parser) {
            JobUpdate update = JobUpdate.PARSER.apply(parser, null).setJobId(jobId).build();
            return new Request(jobId, update);
        }

        public Request(String jobId, JobUpdate update) {
            this(jobId, update, false);
        }

        private Request(String jobId, JobUpdate update, boolean isInternal) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.jobId = jobId;
            this.update = update;
            this.isInternal = isInternal;
            if (Strings.isAllOrWildcard(jobId)) {
                throw ExceptionsHelper.badRequestException("Cannot update more than 1 job at a time", new Object[0]);
            }
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.update = new JobUpdate(in);
            this.isInternal = in.readBoolean();
        }

        public static Request internal(String jobId, JobUpdate update) {
            return new Request(jobId, update, true);
        }

        public String getJobId() {
            return this.jobId;
        }

        public JobUpdate getJobUpdate() {
            return this.update;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            this.update.writeTo(out);
            out.writeBoolean(this.isInternal);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.update.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.update, that.update) && this.isInternal == that.isInternal;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.update, this.isInternal);
        }

        @Override
        public final String toString() {
            return Strings.toString(this);
        }
    }
}

