/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class CreateTrainedModelAssignmentAction
extends ActionType<Response> {
    public static final CreateTrainedModelAssignmentAction INSTANCE = new CreateTrainedModelAssignmentAction();
    public static final String NAME = "cluster:internal/xpack/ml/model_allocation/create";

    private CreateTrainedModelAssignmentAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private static final ParseField ASSIGNMENT = new ParseField("assignment", new String[0]);
        private static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser("create_trained_model_assignment_response", a -> new Response((TrainedModelAssignment)a[0]));
        private final TrainedModelAssignment trainedModelAssignment;

        static Response fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Response(TrainedModelAssignment trainedModelAssignment) {
            this.trainedModelAssignment = trainedModelAssignment;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.trainedModelAssignment = new TrainedModelAssignment(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.trainedModelAssignment.writeTo(out);
        }

        public TrainedModelAssignment getTrainedModelAssignment() {
            return this.trainedModelAssignment;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ASSIGNMENT.getPreferredName(), this.trainedModelAssignment);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.trainedModelAssignment, response.trainedModelAssignment);
        }

        public int hashCode() {
            return Objects.hash(this.trainedModelAssignment);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TrainedModelAssignment.fromXContent(p), ASSIGNMENT);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final StartTrainedModelDeploymentAction.TaskParams taskParams;
        private final AdaptiveAllocationsSettings adaptiveAllocationsSettings;

        public Request(StartTrainedModelDeploymentAction.TaskParams taskParams, AdaptiveAllocationsSettings adaptiveAllocationsSettings) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.taskParams = ExceptionsHelper.requireNonNull(taskParams, "taskParams");
            this.adaptiveAllocationsSettings = adaptiveAllocationsSettings;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskParams = new StartTrainedModelDeploymentAction.TaskParams(in);
            this.adaptiveAllocationsSettings = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readOptionalWriteable(AdaptiveAllocationsSettings::new) : null;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.taskParams.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
                out.writeOptionalWriteable(this.adaptiveAllocationsSettings);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskParams, request.taskParams) && Objects.equals(this.adaptiveAllocationsSettings, request.adaptiveAllocationsSettings);
        }

        public int hashCode() {
            return Objects.hash(this.taskParams, this.adaptiveAllocationsSettings);
        }

        public StartTrainedModelDeploymentAction.TaskParams getTaskParams() {
            return this.taskParams;
        }

        public AdaptiveAllocationsSettings getAdaptiveAllocationsSettings() {
            return this.adaptiveAllocationsSettings;
        }
    }
}

