/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class Step {
    private final StepKey key;
    private final StepKey nextStepKey;

    @Nullable
    public static StepKey getCurrentStepKey(LifecycleExecutionState lifecycleState) {
        Objects.requireNonNull(lifecycleState, "cannot determine current step key as lifecycle state is null");
        String currentPhase = lifecycleState.phase();
        String currentAction = lifecycleState.action();
        String currentStep = lifecycleState.step();
        if (Strings.isNullOrEmpty(currentStep)) {
            assert (Strings.isNullOrEmpty(currentPhase)) : "Current phase is not empty: " + currentPhase;
            assert (Strings.isNullOrEmpty(currentAction)) : "Current action is not empty: " + currentAction;
            return null;
        }
        assert (!Strings.isNullOrEmpty(currentPhase));
        assert (!Strings.isNullOrEmpty(currentAction));
        return new StepKey(currentPhase, currentAction, currentStep);
    }

    public Step(StepKey key, StepKey nextStepKey) {
        this.key = key;
        this.nextStepKey = nextStepKey;
    }

    public final StepKey getKey() {
        return this.key;
    }

    public StepKey getNextStepKey() {
        return this.nextStepKey;
    }

    public abstract boolean isRetryable();

    public int hashCode() {
        return Objects.hash(this.key, this.nextStepKey);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Step other = (Step)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.nextStepKey, other.nextStepKey);
    }

    public String toString() {
        return String.valueOf(this.key) + " => " + String.valueOf(this.nextStepKey);
    }

    public record StepKey(String phase, String action, String name) implements Writeable,
    ToXContentObject
    {
        public static final ParseField PHASE_FIELD = new ParseField("phase", new String[0]);
        public static final ParseField ACTION_FIELD = new ParseField("action", new String[0]);
        public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private static final ConstructingObjectParser<StepKey, Void> PARSER = new ConstructingObjectParser("stepkey", a -> new StepKey((String)a[0], (String)a[1], (String)a[2]));

        public static StepKey readFrom(StreamInput in) throws IOException {
            return new StepKey(in.readString(), in.readString(), in.readString());
        }

        public static StepKey parse(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.phase);
            out.writeString(this.action);
            out.writeString(this.name);
        }

        @Override
        public String toString() {
            return "{\"phase\":\"" + this.phase + "\",\"action\":\"" + this.action + "\",\"name\":\"" + this.name + "\"}";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PHASE_FIELD.getPreferredName(), this.phase);
            builder.field(ACTION_FIELD.getPreferredName(), this.action);
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), PHASE_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTION_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        }
    }
}

