/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;

public final class EnrichMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "enrich";
    static final ParseField POLICIES = new ParseField("policies", new String[0]);
    public static final EnrichMetadata EMPTY = new EnrichMetadata(Collections.emptyMap());
    private static final ConstructingObjectParser<EnrichMetadata, Void> PARSER = new ConstructingObjectParser("enrich_metadata", args -> new EnrichMetadata((Map)args[0]));
    private final Map<String, EnrichPolicy> policies;

    public static EnrichMetadata fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public EnrichMetadata(StreamInput in) throws IOException {
        this(in.readMap(EnrichPolicy::new));
    }

    public EnrichMetadata(Map<String, EnrichPolicy> policies) {
        this.policies = Collections.unmodifiableMap(policies);
    }

    public Map<String, EnrichPolicy> getPolicies() {
        return this.policies;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_5_0;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.policies, StreamOutput::writeWriteable);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).xContentObjectFieldObjects(POLICIES.getPreferredName(), this.policies);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichMetadata that = (EnrichMetadata)o;
        return this.policies.equals(that.policies);
    }

    public int hashCode() {
        return Objects.hash(this.policies);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, EnrichPolicy> patterns = new HashMap<String, EnrichPolicy>();
            String fieldName = null;
            XContentParser.Token token = p.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = p.currentName();
                } else if (token == XContentParser.Token.START_OBJECT) {
                    patterns.put(fieldName, EnrichPolicy.fromXContent(p));
                } else {
                    throw new ElasticsearchParseException("unexpected token [" + String.valueOf((Object)token) + "]", new Object[0]);
                }
                token = p.nextToken();
            }
            return patterns;
        }, POLICIES);
    }
}

