/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class IteratingActionListener<T, U>
implements ActionListener<T>,
Runnable {
    private final List<U> consumables;
    private final ActionListener<T> delegate;
    private final BiConsumer<U, ActionListener<T>> consumer;
    private final ThreadContext threadContext;
    private final Function<T, T> finalResultFunction;
    private final Predicate<T> iterationPredicate;
    private int position = 0;

    public IteratingActionListener(ActionListener<T> delegate, BiConsumer<U, ActionListener<T>> consumer, List<U> consumables, ThreadContext threadContext) {
        this(delegate, consumer, consumables, threadContext, Function.identity());
    }

    public IteratingActionListener(ActionListener<T> delegate, BiConsumer<U, ActionListener<T>> consumer, List<U> consumables, ThreadContext threadContext, Function<T, T> finalResultFunction) {
        this(delegate, consumer, consumables, threadContext, finalResultFunction, Objects::isNull);
    }

    public IteratingActionListener(ActionListener<T> delegate, BiConsumer<U, ActionListener<T>> consumer, List<U> consumables, ThreadContext threadContext, Function<T, T> finalResultFunction, Predicate<T> iterationPredicate) {
        this.delegate = delegate;
        this.consumer = consumer;
        this.consumables = Collections.unmodifiableList(consumables);
        this.threadContext = threadContext;
        this.finalResultFunction = finalResultFunction;
        this.iterationPredicate = iterationPredicate;
    }

    @Override
    public void run() {
        if (this.consumables.isEmpty()) {
            this.onResponse((T)null);
        } else if (this.position < 0 || this.position >= this.consumables.size()) {
            this.onFailure(new IllegalStateException("invalid position [" + this.position + "]. List size [" + this.consumables.size() + "]"));
        } else {
            try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
                this.consumer.accept((IteratingActionListener)this.consumables.get(this.position++), this);
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }
    }

    @Override
    public void onResponse(T response) {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
            boolean continueIteration = this.iterationPredicate.test(response);
            if (continueIteration) {
                if (this.position == this.consumables.size()) {
                    this.delegate.onResponse(this.finalResultFunction.apply(response));
                } else {
                    try {
                        this.consumer.accept((IteratingActionListener)this.consumables.get(this.position++), this);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }
            } else {
                this.delegate.onResponse(this.finalResultFunction.apply(response));
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
            this.delegate.onFailure(e);
        }
    }
}

