/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class ActivateAutoFollowPatternAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "cluster:admin/xpack/ccr/auto_follow_pattern/activate";
    public static final ActivateAutoFollowPatternAction INSTANCE = new ActivateAutoFollowPatternAction();

    private ActivateAutoFollowPatternAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String name;
        private final boolean active;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String name, boolean active) {
            super(masterNodeTimeout, ackTimeout);
            this.name = name;
            this.active = active;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null) {
                validationException = ValidateActions.addValidationError("[name] is missing", validationException);
            }
            return validationException;
        }

        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return this.active;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.active = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeBoolean(this.active);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.active == request.active && Objects.equals(this.name, request.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.active);
        }
    }
}

