/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultRequest;
import org.elasticsearch.xpack.core.async.DeleteAsyncResultsService;

public class TransportDeleteAsyncResultAction
extends HandledTransportAction<DeleteAsyncResultRequest, AcknowledgedResponse> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("indices:data/read/async_search/delete");
    private final DeleteAsyncResultsService deleteResultsService;
    private final ClusterService clusterService;
    private final TransportService transportService;

    @Inject
    public TransportDeleteAsyncResultAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, ThreadPool threadPool, BigArrays bigArrays) {
        super(TYPE.name(), transportService, actionFilters, DeleteAsyncResultRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transportService = transportService;
        this.clusterService = clusterService;
        AsyncTaskIndexService<AsyncResponse> store = new AsyncTaskIndexService<AsyncResponse>(".async-search", clusterService, threadPool.getThreadContext(), client, "async_search", in -> {
            throw new UnsupportedOperationException("Reading is not supported during deletion");
        }, registry, bigArrays);
        this.deleteResultsService = new DeleteAsyncResultsService(store, transportService.getTaskManager());
    }

    @Override
    protected void doExecute(Task task, DeleteAsyncResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        AsyncExecutionId searchId = AsyncExecutionId.decode(request.getId());
        DiscoveryNode node = this.clusterService.state().nodes().get(searchId.getTaskId().getNodeId());
        if (this.clusterService.localNode().getId().equals(searchId.getTaskId().getNodeId()) || node == null) {
            this.deleteResultsService.deleteResponse(request, listener);
        } else {
            this.transportService.sendRequest(node, TYPE.name(), request, new ActionListenerResponseHandler<AcknowledgedResponse>(listener, AcknowledgedResponse::readFrom, EsExecutors.DIRECT_EXECUTOR_SERVICE));
        }
    }
}

