/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Set;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class Transports
extends Enum<Transports> {
    private static final Set<String> REQUEST_HEADERS_ALLOWED_ON_DEFAULT_THREAD_CONTEXT;
    public static final String TEST_MOCK_TRANSPORT_THREAD_PREFIX = "__mock_network_thread";
    private static final String[] TRANSPORT_THREAD_NAMES;
    private static final /* synthetic */ Transports[] $VALUES;

    public static Transports[] values() {
        return (Transports[])$VALUES.clone();
    }

    public static Transports valueOf(String name) {
        return Enum.valueOf(Transports.class, name);
    }

    public static boolean isTransportThread(Thread t) {
        return Transports.isTransportThread(t.getName());
    }

    public static boolean isTransportThread(String threadName) {
        for (String s : TRANSPORT_THREAD_NAMES) {
            if (!threadName.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean assertTransportThread() {
        Thread t = Thread.currentThread();
        assert (Transports.isTransportThread(t)) : "Expected transport thread but got [" + String.valueOf(t) + "]";
        return true;
    }

    public static boolean assertNotTransportThread(String reason) {
        Thread t = Thread.currentThread();
        assert (!Transports.isTransportThread(t)) : "Expected current thread [" + String.valueOf(t) + "] to not be a transport thread. Reason: [" + reason + "]";
        return true;
    }

    public static boolean assertDefaultThreadContext(ThreadContext threadContext) {
        assert (threadContext.getRequestHeadersOnly().isEmpty() || REQUEST_HEADERS_ALLOWED_ON_DEFAULT_THREAD_CONTEXT.containsAll(threadContext.getRequestHeadersOnly().keySet())) : "expected empty context but was " + String.valueOf(threadContext.getRequestHeadersOnly()) + " on " + Thread.currentThread().getName();
        return true;
    }

    private static /* synthetic */ Transports[] $values() {
        return new Transports[0];
    }

    static {
        $VALUES = Transports.$values();
        REQUEST_HEADERS_ALLOWED_ON_DEFAULT_THREAD_CONTEXT = Set.of("trace.id", "traceparent", "X-Opaque-Id", "X-elastic-product-origin");
        TRANSPORT_THREAD_NAMES = new String[]{"[http_server_worker]", "[transport_worker]", TEST_MOCK_TRANSPORT_THREAD_PREFIX};
    }
}

