/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.Map;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;

public final class SearchableSnapshotsSettings {
    public static final String SEARCHABLE_SNAPSHOT_STORE_TYPE = "snapshot";
    public static final String SEARCHABLE_SNAPSHOT_PARTIAL_SETTING_KEY = "index.store.snapshot.partial";
    public static final Setting<Boolean> SNAPSHOT_PARTIAL_SETTING = Setting.boolSetting("index.store.snapshot.partial", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize);
    public static final String SEARCHABLE_SNAPSHOTS_REPOSITORY_NAME_SETTING_KEY = "index.store.snapshot.repository_name";
    public static final String SEARCHABLE_SNAPSHOTS_REPOSITORY_UUID_SETTING_KEY = "index.store.snapshot.repository_uuid";
    public static final String SEARCHABLE_SNAPSHOTS_SNAPSHOT_NAME_SETTING_KEY = "index.store.snapshot.snapshot_name";
    public static final String SEARCHABLE_SNAPSHOTS_SNAPSHOT_UUID_SETTING_KEY = "index.store.snapshot.snapshot_uuid";
    public static final String SEARCHABLE_SNAPSHOTS_DELETE_SNAPSHOT_ON_INDEX_DELETION = "index.store.snapshot.delete_searchable_snapshot";
    public static final String SEARCHABLE_SNAPSHOT_INDEX_NAME_SETTING_KEY = "index.store.snapshot.index_name";

    private SearchableSnapshotsSettings() {
    }

    public static boolean isSearchableSnapshotStore(Settings indexSettings) {
        return SEARCHABLE_SNAPSHOT_STORE_TYPE.equals(IndexModule.INDEX_STORE_TYPE_SETTING.get(indexSettings));
    }

    public static boolean isPartialSearchableSnapshotIndex(Settings indexSettings) {
        return SearchableSnapshotsSettings.isSearchableSnapshotStore(indexSettings) && indexSettings.getAsBoolean(SEARCHABLE_SNAPSHOT_PARTIAL_SETTING_KEY, false) != false;
    }

    public static boolean isPartialSearchableSnapshotIndex(Map<Setting<?>, Object> indexSettings) {
        assert (indexSettings.containsKey(IndexModule.INDEX_STORE_TYPE_SETTING)) : "must include store type in map";
        assert (indexSettings.get(SNAPSHOT_PARTIAL_SETTING) != null) : "partial setting must be non-null in map (has default value)";
        return SEARCHABLE_SNAPSHOT_STORE_TYPE.equals(indexSettings.get(IndexModule.INDEX_STORE_TYPE_SETTING)) && (Boolean)indexSettings.get(SNAPSHOT_PARTIAL_SETTING) != false;
    }
}

