/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.sort.SortOrder;

public class MinAndMax<T extends Comparable<? super T>>
implements Writeable {
    private final T minValue;
    private final T maxValue;
    private static final Comparator<MinAndMax> ASC_COMPARATOR = (left, right) -> {
        if (left == null) {
            return right == null ? 0 : -1;
        }
        return right == null ? 1 : left.getMin().compareTo(right.getMin());
    };
    private static final Comparator<MinAndMax> DESC_COMPARATOR = (left, right) -> {
        if (left == null) {
            return right == null ? 0 : 1;
        }
        return right == null ? -1 : right.getMax().compareTo(left.getMax());
    };

    public MinAndMax(T minValue, T maxValue) {
        this.minValue = (Comparable)Objects.requireNonNull(minValue);
        this.maxValue = (Comparable)Objects.requireNonNull(maxValue);
    }

    public MinAndMax(StreamInput in) throws IOException {
        this.minValue = Lucene.readSortValue(in);
        this.maxValue = Lucene.readSortValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Lucene.writeSortValue(out, this.minValue);
        Lucene.writeSortValue(out, this.maxValue);
    }

    public T getMin() {
        return this.minValue;
    }

    public T getMax() {
        return this.maxValue;
    }

    public static <T extends Comparable<? super T>> Comparator<MinAndMax<T>> getComparator(SortOrder order) {
        return order == SortOrder.ASC ? ASC_COMPARATOR : DESC_COMPARATOR;
    }
}

