/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldAutomatonQuery;

public class StringScriptFieldWildcardQuery
extends AbstractStringScriptFieldAutomatonQuery {
    private final String pattern;
    private final boolean caseInsensitive;

    public StringScriptFieldWildcardQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, String pattern, boolean caseInsensitive) {
        super(script, leafFactory, fieldName, new ByteRunAutomaton(StringScriptFieldWildcardQuery.buildAutomaton(new Term(fieldName, Objects.requireNonNull(pattern)), caseInsensitive)));
        this.pattern = pattern;
        this.caseInsensitive = caseInsensitive;
    }

    private static Automaton buildAutomaton(Term term, boolean caseInsensitive) {
        if (caseInsensitive) {
            return AutomatonQueries.toCaseInsensitiveWildcardAutomaton(term);
        }
        return WildcardQuery.toAutomaton(term);
    }

    @Override
    public final String toString(String field) {
        if (this.fieldName().equals(field)) {
            return this.pattern;
        }
        return this.fieldName() + ":" + this.pattern;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern, this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        StringScriptFieldWildcardQuery other = (StringScriptFieldWildcardQuery)obj;
        return this.pattern.equals(other.pattern) && this.caseInsensitive == other.caseInsensitive;
    }

    String pattern() {
        return this.pattern;
    }

    boolean caseInsensitive() {
        return this.caseInsensitive;
    }
}

