/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractScriptFieldQuery;

public final class GeoPointScriptFieldDistanceFeatureQuery
extends AbstractScriptFieldQuery<AbstractLongFieldScript> {
    private final double originLat;
    private final double originLon;
    private final double pivotDistance;

    public GeoPointScriptFieldDistanceFeatureQuery(Script script, Function<LeafReaderContext, AbstractLongFieldScript> leafFactory, String fieldName, double originLat, double originLon, double pivotDistance) {
        super(script, fieldName, leafFactory);
        GeoUtils.checkLatitude(originLat);
        GeoUtils.checkLongitude(originLon);
        this.originLon = originLon;
        this.originLat = originLat;
        if (pivotDistance <= 0.0) {
            throw new IllegalArgumentException("pivotDistance must be > 0, got " + pivotDistance);
        }
        this.pivotDistance = pivotDistance;
    }

    double lat() {
        return this.originLat;
    }

    double lon() {
        return this.originLon;
    }

    double pivot() {
        return this.pivotDistance;
    }

    @Override
    protected boolean matches(AbstractLongFieldScript scriptContext, int docId) {
        scriptContext.runForDoc(docId);
        return scriptContext.count() > 0;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) {
        return new Weight(this){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public Scorer scorer(LeafReaderContext context) {
                return new DistanceScorer(this, (AbstractLongFieldScript)GeoPointScriptFieldDistanceFeatureQuery.this.scriptContextFunction().apply(context), context.reader().maxDoc(), boost);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) {
                AbstractLongFieldScript script = (AbstractLongFieldScript)GeoPointScriptFieldDistanceFeatureQuery.this.scriptContextFunction().apply(context);
                script.runForDoc(doc);
                long encoded = GeoPointScriptFieldDistanceFeatureQuery.this.valueWithMinAbsoluteDistance(script);
                int latitudeBits = (int)(encoded >> 32);
                int longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL);
                double lat = GeoEncodingUtils.decodeLatitude(latitudeBits);
                double lon = GeoEncodingUtils.decodeLongitude(longitudeBits);
                double distance = SloppyMath.haversinMeters(GeoPointScriptFieldDistanceFeatureQuery.this.originLat, GeoPointScriptFieldDistanceFeatureQuery.this.originLon, lat, lon);
                float score = (float)((double)boost * (GeoPointScriptFieldDistanceFeatureQuery.this.pivotDistance / (GeoPointScriptFieldDistanceFeatureQuery.this.pivotDistance + distance)));
                return Explanation.match((Number)Float.valueOf(score), "Distance score, computed as weight * pivotDistance / (pivotDistance + abs(distance)) from:", Explanation.match((Number)Float.valueOf(boost), "weight", new Explanation[0]), Explanation.match((Number)GeoPointScriptFieldDistanceFeatureQuery.this.pivotDistance, "pivotDistance", new Explanation[0]), Explanation.match((Number)GeoPointScriptFieldDistanceFeatureQuery.this.originLat, "originLat", new Explanation[0]), Explanation.match((Number)GeoPointScriptFieldDistanceFeatureQuery.this.originLon, "originLon", new Explanation[0]), Explanation.match((Number)lat, "current lat", new Explanation[0]), Explanation.match((Number)lon, "current lon", new Explanation[0]), Explanation.match((Number)distance, "distance", new Explanation[0]));
            }
        };
    }

    private double getDistance(AbstractLongFieldScript script) {
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < script.count(); ++i) {
            minDistance = Math.min(minDistance, this.getDistanceFromEncoded(script.values()[i]));
        }
        return minDistance;
    }

    private double getDistanceFromEncoded(long encoded) {
        int latitudeBits = (int)(encoded >> 32);
        int longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL);
        double lat = GeoEncodingUtils.decodeLatitude(latitudeBits);
        double lon = GeoEncodingUtils.decodeLongitude(longitudeBits);
        return SloppyMath.haversinMeters(this.originLat, this.originLon, lat, lon);
    }

    long valueWithMinAbsoluteDistance(AbstractLongFieldScript script) {
        double minDistance = Double.POSITIVE_INFINITY;
        long minDistanceValue = Long.MAX_VALUE;
        for (int i = 0; i < script.count(); ++i) {
            double distance = this.getDistanceFromEncoded(script.values()[i]);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minDistanceValue = script.values()[i];
        }
        return minDistanceValue;
    }

    float score(float weight, double distance) {
        return (float)((double)weight * (this.pivotDistance / (this.pivotDistance + distance)));
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().equals(field)) {
            b.append(this.fieldName()).append(":");
        }
        b.append(this.getClass().getSimpleName());
        b.append("(lat=").append(this.originLat);
        b.append(",lon=").append(this.originLon);
        b.append(",pivot=").append(this.pivotDistance).append(")");
        return b.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originLat, this.originLon, this.pivotDistance);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GeoPointScriptFieldDistanceFeatureQuery other = (GeoPointScriptFieldDistanceFeatureQuery)obj;
        return this.originLon == other.originLon && this.originLat == other.originLat && this.pivotDistance == other.pivotDistance;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            visitor.visitLeaf(this);
        }
    }

    private class DistanceScorer
    extends Scorer {
        private final AbstractLongFieldScript script;
        private final TwoPhaseIterator twoPhase;
        private final DocIdSetIterator disi;
        private final float weight;

        protected DistanceScorer(Weight weight, final AbstractLongFieldScript script, int maxDoc, float boost) {
            super(weight);
            this.script = script;
            this.twoPhase = new TwoPhaseIterator(DocIdSetIterator.all(maxDoc)){

                @Override
                public boolean matches() {
                    return GeoPointScriptFieldDistanceFeatureQuery.this.matches(script, this.approximation.docID());
                }

                @Override
                public float matchCost() {
                    return 9000.0f;
                }
            };
            this.disi = TwoPhaseIterator.asDocIdSetIterator(this.twoPhase);
            this.weight = boost;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public float score() throws IOException {
            if (this.script.count() == 0) {
                return 0.0f;
            }
            return GeoPointScriptFieldDistanceFeatureQuery.this.score(this.weight, GeoPointScriptFieldDistanceFeatureQuery.this.getDistance(this.script));
        }

        @Override
        public float getMaxScore(int upTo) {
            return this.weight;
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.disi;
        }

        @Override
        public TwoPhaseIterator twoPhaseIterator() {
            return this.twoPhase;
        }
    }
}

