/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.context.RankFeaturePhaseRankShardContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class RankBuilder
implements VersionedNamedWriteable,
ToXContentObject {
    public static final ParseField RANK_WINDOW_SIZE_FIELD = new ParseField("rank_window_size", "window_size");
    public static final int DEFAULT_RANK_WINDOW_SIZE = 10;
    private final int rankWindowSize;

    public RankBuilder(int rankWindowSize) {
        this.rankWindowSize = rankWindowSize;
    }

    public RankBuilder(StreamInput in) throws IOException {
        this.rankWindowSize = in.readVInt();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.rankWindowSize);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.getWriteableName());
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
        this.doXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int rankWindowSize() {
        return this.rankWindowSize;
    }

    public abstract boolean isCompoundBuilder();

    public abstract Explanation explainHit(Explanation var1, RankDoc var2, List<String> var3);

    public abstract QueryPhaseRankShardContext buildQueryPhaseShardContext(List<Query> var1, int var2);

    public abstract QueryPhaseRankCoordinatorContext buildQueryPhaseCoordinatorContext(int var1, int var2);

    public abstract RankFeaturePhaseRankShardContext buildRankFeaturePhaseShardContext();

    public abstract RankFeaturePhaseRankCoordinatorContext buildRankFeaturePhaseCoordinatorContext(int var1, int var2, Client var3);

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RankBuilder other = (RankBuilder)obj;
        return this.rankWindowSize == other.rankWindowSize && this.doEquals(other);
    }

    protected abstract boolean doEquals(RankBuilder var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.rankWindowSize, this.doHashCode());
    }

    protected abstract int doHashCode();

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

