/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalTopHits
extends InternalAggregation
implements TopHits {
    private final int from;
    private final int size;
    private final TopDocsAndMaxScore topDocs;
    private final SearchHits searchHits;
    private static final String SOURCE = "_source";
    private static final String SORT_VALUE = "_sort";
    private static final String SCORE = "_score";

    public InternalTopHits(String name, int from, int size, TopDocsAndMaxScore topDocs, SearchHits searchHits, Map<String, Object> metadata) {
        super(name, metadata);
        this.from = from;
        this.size = size;
        this.topDocs = topDocs;
        this.searchHits = searchHits.asUnpooled();
    }

    public InternalTopHits(StreamInput in) throws IOException {
        super(in);
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        this.searchHits = SearchHits.readFrom(in, false);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs);
        this.searchHits.writeTo(out);
    }

    @Override
    public String getWriteableName() {
        return "top_hits";
    }

    @Override
    public SearchHits getHits() {
        return this.searchHits;
    }

    TopDocsAndMaxScore getTopDocs() {
        return this.topDocs;
    }

    int getFrom() {
        return this.from;
    }

    int getSize() {
        return this.size;
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            final List<InternalTopHits> aggregations;
            {
                this.aggregations = new ArrayList<InternalTopHits>(size);
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                this.aggregations.add((InternalTopHits)aggregation);
            }

            @Override
            public InternalAggregation get() {
                TopDocs reducedTopDocs;
                float maxScore;
                TopDocs[] shardDocs;
                int size2;
                int from;
                if (reduceContext.isFinalReduce()) {
                    from = InternalTopHits.this.getFrom();
                    size2 = InternalTopHits.this.getSize();
                } else {
                    from = 0;
                    size2 = InternalTopHits.this.getFrom() + InternalTopHits.this.getSize();
                }
                TopDocs topDocs = InternalTopHits.this.topDocs.topDocs;
                if (topDocs instanceof TopFieldDocs) {
                    TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
                    shardDocs = new TopFieldDocs[this.aggregations.size()];
                    maxScore = InternalTopHits.reduceAndFindMaxScore(this.aggregations, shardDocs);
                    reducedTopDocs = TopDocs.merge(new Sort(topFieldDocs.fields), from, size2, (TopFieldDocs[])shardDocs);
                } else {
                    shardDocs = new TopDocs[this.aggregations.size()];
                    maxScore = InternalTopHits.reduceAndFindMaxScore(this.aggregations, shardDocs);
                    reducedTopDocs = TopDocs.merge(from, size2, shardDocs);
                }
                assert (reducedTopDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
                return new InternalTopHits(InternalTopHits.this.getName(), InternalTopHits.this.getFrom(), InternalTopHits.this.getSize(), new TopDocsAndMaxScore(reducedTopDocs, maxScore), InternalTopHits.extractSearchHits(this.aggregations, reducedTopDocs, shardDocs, maxScore), InternalTopHits.this.getMetadata());
            }
        };
    }

    private static SearchHits extractSearchHits(List<InternalTopHits> aggregations, TopDocs reducedTopDocs, TopDocs[] shardDocs, float maxScore) {
        int[] tracker = new int[aggregations.size()];
        ScoreDoc[] scoreDocs = reducedTopDocs.scoreDocs;
        SearchHit[] hits = new SearchHit[scoreDocs.length];
        for (int i = 0; i < scoreDocs.length; ++i) {
            int position;
            ScoreDoc scoreDoc = scoreDocs[i];
            int shardIndex = scoreDoc.shardIndex;
            TopDocs topDocsForShard = shardDocs[shardIndex];
            do {
                int n = shardIndex;
                tracker[n] = tracker[n] + 1;
            } while (topDocsForShard.scoreDocs[position] != scoreDoc);
            hits[i] = aggregations.get((int)shardIndex).searchHits.getAt(position);
            assert (!hits[i].isPooled());
        }
        return SearchHits.unpooled(hits, reducedTopDocs.totalHits, maxScore);
    }

    private static float reduceAndFindMaxScore(List<InternalTopHits> aggregations, TopDocs[] shardDocs) {
        float maxScore = Float.NaN;
        for (int i = 0; i < shardDocs.length; ++i) {
            InternalTopHits topHitsAgg = aggregations.get(i);
            shardDocs[i] = topHitsAgg.topDocs.topDocs;
            for (ScoreDoc doc : shardDocs[i].scoreDocs) {
                doc.shardIndex = i;
            }
            float max = topHitsAgg.topDocs.maxScore;
            if (Float.isNaN(max)) continue;
            maxScore = Float.isNaN(maxScore) ? max : Math.max(maxScore, max);
        }
        return maxScore;
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() != 1) {
            throw new IllegalArgumentException("property paths for top_hits [" + this.getName() + "] can only contain a single field in _source, score or sort values, got " + String.valueOf(path));
        }
        String[] tokens = path.get(0).toLowerCase(Locale.ROOT).split(":|>|\\.");
        if (this.searchHits.getHits().length > 1) {
            throw new IllegalArgumentException("property paths for top_hits [" + this.getName() + "] require configuring it with size to 1");
        }
        SearchHit topHit = this.searchHits.getAt(0);
        if (tokens[0].equals(SORT_VALUE)) {
            Object[] sortValues = topHit.getSortValues();
            if (sortValues != null) {
                if (sortValues.length != 1) {
                    throw new IllegalArgumentException("property path for top_hits [\" + getName() + \"] requires a single sort value, got " + sortValues.length);
                }
                return sortValues[0];
            }
        } else {
            Object property;
            Map<String, Object> sourceAsMap;
            if (tokens[0].equals(SCORE)) {
                return Float.valueOf(topHit.getScore());
            }
            if (tokens[0].equals(SOURCE) && (sourceAsMap = topHit.getSourceAsMap()) != null && (property = sourceAsMap.get(tokens[1])) != null) {
                return property;
            }
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + String.valueOf(path));
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ChunkedToXContent.wrapAsToXContent(this.searchHits).toXContent(builder, params);
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalTopHits other = (InternalTopHits)obj;
        if (this.from != other.from) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.topDocs.topDocs.totalHits.value != other.topDocs.topDocs.totalHits.value) {
            return false;
        }
        if (this.topDocs.topDocs.totalHits.relation != other.topDocs.topDocs.totalHits.relation) {
            return false;
        }
        if (this.topDocs.topDocs.scoreDocs.length != other.topDocs.topDocs.scoreDocs.length) {
            return false;
        }
        for (int d = 0; d < this.topDocs.topDocs.scoreDocs.length; ++d) {
            ScoreDoc thisDoc = this.topDocs.topDocs.scoreDocs[d];
            ScoreDoc otherDoc = other.topDocs.topDocs.scoreDocs[d];
            if (thisDoc.doc != otherDoc.doc) {
                return false;
            }
            if (Double.compare(thisDoc.score, otherDoc.score) != 0) {
                return false;
            }
            if (!(thisDoc instanceof FieldDoc)) continue;
            FieldDoc thisFieldDoc = (FieldDoc)thisDoc;
            if (!(otherDoc instanceof FieldDoc)) {
                return false;
            }
            FieldDoc otherFieldDoc = (FieldDoc)otherDoc;
            if (thisFieldDoc.fields.length != otherFieldDoc.fields.length) {
                return false;
            }
            for (int f = 0; f < thisFieldDoc.fields.length; ++f) {
                if (thisFieldDoc.fields[f].equals(otherFieldDoc.fields[f])) continue;
                return false;
            }
        }
        return this.searchHits.equals(other.searchHits);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + Integer.hashCode(this.from);
        hashCode = 31 * hashCode + Integer.hashCode(this.size);
        hashCode = 31 * hashCode + Long.hashCode(this.topDocs.topDocs.totalHits.value);
        hashCode = 31 * hashCode + this.topDocs.topDocs.totalHits.relation.hashCode();
        for (int d = 0; d < this.topDocs.topDocs.scoreDocs.length; ++d) {
            ScoreDoc doc = this.topDocs.topDocs.scoreDocs[d];
            hashCode = 31 * hashCode + doc.doc;
            hashCode = 31 * hashCode + Float.floatToIntBits(doc.score);
            if (!(doc instanceof FieldDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)doc;
            hashCode = 31 * hashCode + Arrays.hashCode(fieldDoc.fields);
        }
        hashCode = 31 * hashCode + this.searchHits.hashCode();
        return hashCode;
    }
}

